/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.biome;

import java.util.List;
import java.util.Map;
import java.util.function.IntConsumer;
import net.fabricmc.fabric.api.biomes.v1.OverworldClimate;
import net.fabricmc.fabric.impl.biome.ContinentalBiomeEntry;
import net.fabricmc.fabric.impl.biome.InternalBiomeData;
import net.fabricmc.fabric.impl.biome.VariantTransformer;
import net.fabricmc.fabric.impl.biome.WeightedBiomePicker;
import net.fabricmc.fabric.mixin.biome.DimensionOptionsAccessor;
import net.fabricmc.fabric.mixin.biome.DimensionTypeAccessor;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3630;
import net.minecraft.class_5285;
import net.minecraft.class_5363;
import net.minecraft.class_5458;

public final class InternalBiomeUtils {
    private InternalBiomeUtils() {
    }

    public static boolean isEdge(int north, int east, int south, int west, int center) {
        return InternalBiomeUtils.areUnsimilar(center, north) || InternalBiomeUtils.areUnsimilar(center, east) || InternalBiomeUtils.areUnsimilar(center, south) || InternalBiomeUtils.areUnsimilar(center, west);
    }

    private static boolean areUnsimilar(int mainBiomeId, int secondaryBiomeId) {
        if (mainBiomeId == secondaryBiomeId) {
            return false;
        }
        class_1959 secondaryBiome = (class_1959)class_5458.field_25933.method_10200(secondaryBiomeId);
        class_1959 mainBiome = (class_1959)class_5458.field_25933.method_10200(mainBiomeId);
        boolean isUnsimilar = secondaryBiome.method_8723() ? mainBiomeId != class_5458.field_25933.method_10206(class_5458.field_25933.method_10223(new class_2960(secondaryBiome.method_8725()))) : true;
        isUnsimilar = isUnsimilar && (!mainBiome.method_8723() || secondaryBiomeId != class_5458.field_25933.method_10206(class_5458.field_25933.method_10223(new class_2960(mainBiome.method_8725()))));
        return isUnsimilar;
    }

    public static boolean neighborsOcean(int north, int east, int south, int west) {
        return InternalBiomeUtils.isOceanBiome(north) || InternalBiomeUtils.isOceanBiome(east) || InternalBiomeUtils.isOceanBiome(south) || InternalBiomeUtils.isOceanBiome(west);
    }

    private static boolean isOceanBiome(int id) {
        class_1959 biome = (class_1959)class_5458.field_25933.method_10200(id);
        return biome != null && biome.method_8688() == class_1959.class_1961.field_9367;
    }

    public static int searchForBiome(double reqWeightSum, int vanillaArrayWeight, List<ContinentalBiomeEntry> moddedBiomes) {
        reqWeightSum -= (double)vanillaArrayWeight;
        int low = 0;
        int high = moddedBiomes.size() - 1;
        while (low < high) {
            int mid = high + low >>> 1;
            if (reqWeightSum < moddedBiomes.get(mid).getUpperWeightBound()) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return low;
    }

    public static int transformBiome(class_3630 random, class_1959 existing, OverworldClimate climate) {
        Map<class_1959, VariantTransformer> overworldVariantTransformers = InternalBiomeData.getOverworldVariantTransformers();
        VariantTransformer transformer = overworldVariantTransformers.get(existing);
        if (transformer != null) {
            return class_5458.field_25933.method_10206((Object)transformer.transformBiome(existing, random, climate));
        }
        return class_5458.field_25933.method_10206((Object)existing);
    }

    public static void injectBiomesIntoClimate(class_3630 random, int[] vanillaArray, OverworldClimate climate, IntConsumer result) {
        WeightedBiomePicker picker = InternalBiomeData.getOverworldModdedContinentalBiomePickers().get((Object)climate);
        if (picker == null || picker.getCurrentWeightTotal() <= 0.0) {
            return;
        }
        int vanillaArrayWeight = vanillaArray.length;
        double reqWeightSum = (double)random.method_15834(Integer.MAX_VALUE) * ((double)vanillaArray.length + picker.getCurrentWeightTotal()) / 2.147483647E9;
        if (reqWeightSum < (double)vanillaArray.length) {
            result.accept(InternalBiomeUtils.transformBiome(random, (class_1959)class_5458.field_25933.method_10200(vanillaArray[(int)reqWeightSum]), climate));
        } else {
            ContinentalBiomeEntry found = picker.search(reqWeightSum - (double)vanillaArrayWeight);
            result.accept(InternalBiomeUtils.transformBiome(random, found.getBiome(), climate));
        }
    }

    public static void recreateChunkGenerators(class_5285 generatorOptions) {
        ((DimensionOptionsAccessor)generatorOptions.method_28609().method_29107(class_5363.field_25413)).setChunkGenerator(DimensionTypeAccessor.createNetherGenerator(generatorOptions.method_28028()));
    }
}

