/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.blockrenderlayer;

import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_3611;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockRenderLayerMapImpl
implements BlockRenderLayerMap {
    public static final BlockRenderLayerMap INSTANCE = new BlockRenderLayerMapImpl();
    private static final Logger LOG = LogManager.getLogger();
    private static BiConsumer<class_2248, class_1921> blockHandler = (b, l) -> LOG.warn("Unable to map Block {} to BlockRenderLayer. Mapping handler not ready.", b);
    private static BiConsumer<class_3611, class_1921> fluidHandler = (f, b) -> LOG.warn("Unable to map Fluid {} to BlockRenderLayer. Mapping handler not ready.", f);

    private BlockRenderLayerMapImpl() {
    }

    @Override
    public void putBlock(class_2248 block, class_1921 renderLayer) {
        if (block == null) {
            LOG.warn("Ignoring request to map null block to BlockRenderLayer");
        } else if (renderLayer == null) {
            LOG.warn("Ignoring request to map block " + block.toString() + " to null BlockRenderLayer");
        } else {
            blockHandler.accept(block, renderLayer);
        }
    }

    @Override
    public void putFluid(class_3611 fluid, class_1921 renderLayer) {
        if (fluid == null) {
            LOG.warn("Ignoring request to map null fluid to BlockRenderLayer");
        } else if (renderLayer == null) {
            LOG.warn("Ignoring request to map fluid " + fluid.toString() + " to null BlockRenderLayer");
        } else {
            fluidHandler.accept(fluid, renderLayer);
        }
    }

    public static void initialize(BiConsumer<class_2248, class_1921> blockHandlerIn, BiConsumer<class_3611, class_1921> fluidHandlerIn) {
        blockHandler = blockHandlerIn;
        fluidHandler = fluidHandlerIn;
    }
}

