/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.gametest;

import java.util.List;
import net.fabricmc.fabric.api.client.gametest.v1.ClientGameTestContext;
import net.fabricmc.fabric.api.client.gametest.v1.FabricClientGameTest;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import net.minecraft.class_442;

public class FabricClientGameTestRunner {
	private static final String ENTRYPOINT_KEY = "fabric-client-gametest";

	public static void start() {
		// make the game think the window is focused
		class_310.method_1551().method_15995(true);

		List<FabricClientGameTest> gameTests = FabricLoader.getInstance().getEntrypoints(ENTRYPOINT_KEY, FabricClientGameTest.class);

		ThreadingImpl.runTestThread(() -> {
			ClientGameTestContextImpl context = new ClientGameTestContextImpl();

			for (FabricClientGameTest gameTest : gameTests) {
				context.restoreDefaultGameOptions();

				try {
					gameTest.runTest(context);
				} finally {
					context.getInput().clearKeysDown();
					checkFinalGameTestState(context, gameTest.getClass().getName());
				}
			}

			context.clickScreenButton("menu.quit");
		});
	}

	private static void checkFinalGameTestState(ClientGameTestContext context, String testClassName) {
		if (ThreadingImpl.isServerRunning) {
			throw new AssertionError("Client gametest %s finished while a server is still running".formatted(testClassName));
		}

		context.runOnClient(client -> {
			if (client.method_1562() != null) {
				throw new AssertionError("Client gametest %s finished while still connected to a server".formatted(testClassName));
			}

			if (!(client.field_1755 instanceof class_442)) {
				throw new AssertionError("Client gametest %s did not finish on the title screen".formatted(testClassName));
			}
		});
	}
}
