/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.gametest;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.gametest.v1.ClientGameTestContext;
import net.fabricmc.fabric.api.client.gametest.v1.ClientGameTestInput;
import net.fabricmc.fabric.impl.client.gametest.ThreadingImpl;
import net.fabricmc.fabric.mixin.client.gametest.KeyBindingAccessor;
import net.fabricmc.fabric.mixin.client.gametest.KeyboardAccessor;
import net.fabricmc.fabric.mixin.client.gametest.MouseAccessor;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3675;

@Environment(value=EnvType.CLIENT)
public final class ClientGameTestInputImpl
implements ClientGameTestInput {
    private static final Set<class_3675.class_306> KEYS_DOWN = new HashSet<class_3675.class_306>();
    private final ClientGameTestContext context;

    public ClientGameTestInputImpl(ClientGameTestContext context) {
        this.context = context;
    }

    public static boolean isKeyDown(int keyCode) {
        return KEYS_DOWN.contains(class_3675.class_307.field_1668.method_1447(keyCode));
    }

    public void clearKeysDown() {
        for (class_3675.class_306 key : new ArrayList<class_3675.class_306>(KEYS_DOWN)) {
            this.releaseKey(key);
        }
    }

    @Override
    public void holdKey(class_304 keyBinding) {
        ThreadingImpl.checkOnGametestThread("holdKey");
        Preconditions.checkNotNull((Object)keyBinding, (Object)"keyBinding");
        this.holdKey(ClientGameTestInputImpl.getBoundKey(keyBinding, "hold"));
    }

    @Override
    public void holdKey(Function<class_315, class_304> keyBindingGetter) {
        ThreadingImpl.checkOnGametestThread("holdKey");
        Preconditions.checkNotNull(keyBindingGetter, (Object)"keyBindingGetter");
        class_304 keyBinding = (class_304)this.context.computeOnClient(client -> (class_304)keyBindingGetter.apply(client.field_1690));
        this.holdKey(keyBinding);
    }

    @Override
    public void holdKey(class_3675.class_306 key) {
        ThreadingImpl.checkOnGametestThread("holdKey");
        Preconditions.checkNotNull((Object)key, (Object)"key");
        if (KEYS_DOWN.add(key)) {
            this.context.runOnClient(client -> ClientGameTestInputImpl.pressOrReleaseKey(client, key, 1));
        }
    }

    @Override
    public void holdKey(int keyCode) {
        ThreadingImpl.checkOnGametestThread("holdKey");
        this.holdKey(class_3675.class_307.field_1668.method_1447(keyCode));
    }

    @Override
    public void holdMouse(int button) {
        ThreadingImpl.checkOnGametestThread("holdMouse");
        this.holdKey(class_3675.class_307.field_1672.method_1447(button));
    }

    @Override
    public void holdControl() {
        ThreadingImpl.checkOnGametestThread("holdControl");
        this.holdKey(class_310.field_1703 ? 343 : 341);
    }

    @Override
    public void holdShift() {
        ThreadingImpl.checkOnGametestThread("holdShift");
        this.holdKey(340);
    }

    @Override
    public void holdAlt() {
        ThreadingImpl.checkOnGametestThread("holdAlt");
        this.holdKey(342);
    }

    @Override
    public void releaseKey(class_304 keyBinding) {
        ThreadingImpl.checkOnGametestThread("releaseKey");
        Preconditions.checkNotNull((Object)keyBinding, (Object)"keyBinding");
        this.releaseKey(ClientGameTestInputImpl.getBoundKey(keyBinding, "release"));
    }

    @Override
    public void releaseKey(Function<class_315, class_304> keyBindingGetter) {
        ThreadingImpl.checkOnGametestThread("releaseKey");
        Preconditions.checkNotNull(keyBindingGetter, (Object)"keyBindingGetter");
        class_304 keyBinding = (class_304)this.context.computeOnClient(client -> (class_304)keyBindingGetter.apply(client.field_1690));
        this.releaseKey(keyBinding);
    }

    @Override
    public void releaseKey(class_3675.class_306 key) {
        ThreadingImpl.checkOnGametestThread("releaseKey");
        Preconditions.checkNotNull((Object)key, (Object)"key");
        if (KEYS_DOWN.remove(key)) {
            this.context.runOnClient(client -> ClientGameTestInputImpl.pressOrReleaseKey(client, key, 0));
        }
    }

    @Override
    public void releaseKey(int keyCode) {
        ThreadingImpl.checkOnGametestThread("releaseKey");
        this.releaseKey(class_3675.class_307.field_1668.method_1447(keyCode));
    }

    @Override
    public void releaseMouse(int button) {
        ThreadingImpl.checkOnGametestThread("releaseMouse");
        this.releaseKey(class_3675.class_307.field_1672.method_1447(button));
    }

    @Override
    public void releaseControl() {
        ThreadingImpl.checkOnGametestThread("releaseControl");
        this.releaseKey(class_310.field_1703 ? 343 : 341);
    }

    @Override
    public void releaseShift() {
        ThreadingImpl.checkOnGametestThread("releaseShift");
        this.releaseKey(340);
    }

    @Override
    public void releaseAlt() {
        ThreadingImpl.checkOnGametestThread("releaseAlt");
        this.releaseKey(342);
    }

    private static void pressOrReleaseKey(class_310 client, class_3675.class_306 key, int action) {
        switch (key.method_1442()) {
            case field_1668: {
                client.field_1774.method_1466(client.method_22683().method_4490(), key.method_1444(), 0, action, 0);
                break;
            }
            case field_1671: {
                client.field_1774.method_1466(client.method_22683().method_4490(), -1, key.method_1444(), action, 0);
                break;
            }
            case field_1672: {
                ((MouseAccessor)client.field_1729).invokeOnMouseButton(client.method_22683().method_4490(), key.method_1444(), action, 0);
            }
        }
    }

    @Override
    public void pressKey(class_304 keyBinding) {
        ThreadingImpl.checkOnGametestThread("pressKey");
        Preconditions.checkNotNull((Object)keyBinding, (Object)"keyBinding");
        this.pressKey(ClientGameTestInputImpl.getBoundKey(keyBinding, "press"));
    }

    @Override
    public void pressKey(Function<class_315, class_304> keyBindingGetter) {
        ThreadingImpl.checkOnGametestThread("pressKey");
        Preconditions.checkNotNull(keyBindingGetter, (Object)"keyBindingGetter");
        class_304 keyBinding = (class_304)this.context.computeOnClient(client -> (class_304)keyBindingGetter.apply(client.field_1690));
        this.pressKey(keyBinding);
    }

    @Override
    public void pressKey(class_3675.class_306 key) {
        ThreadingImpl.checkOnGametestThread("pressKey");
        Preconditions.checkNotNull((Object)key, (Object)"key");
        this.holdKey(key);
        this.releaseKey(key);
    }

    @Override
    public void pressKey(int keyCode) {
        ThreadingImpl.checkOnGametestThread("pressKey");
        this.pressKey(class_3675.class_307.field_1668.method_1447(keyCode));
    }

    @Override
    public void pressMouse(int button) {
        ThreadingImpl.checkOnGametestThread("pressMouse");
        this.pressKey(class_3675.class_307.field_1672.method_1447(button));
    }

    @Override
    public void holdKeyFor(class_304 keyBinding, int ticks) {
        ThreadingImpl.checkOnGametestThread("holdKeyFor");
        Preconditions.checkNotNull((Object)keyBinding, (Object)"keyBinding");
        Preconditions.checkArgument((ticks > 0 ? 1 : 0) != 0, (Object)"ticks must be positive");
        this.holdKeyFor(ClientGameTestInputImpl.getBoundKey(keyBinding, "hold"), ticks);
    }

    @Override
    public void holdKeyFor(Function<class_315, class_304> keyBindingGetter, int ticks) {
        ThreadingImpl.checkOnGametestThread("holdKeyFor");
        Preconditions.checkNotNull(keyBindingGetter, (Object)"keyBindingGetter");
        Preconditions.checkArgument((ticks > 0 ? 1 : 0) != 0, (Object)"ticks must be positive");
        class_304 keyBinding = (class_304)this.context.computeOnClient(client -> (class_304)keyBindingGetter.apply(client.field_1690));
        this.holdKeyFor(keyBinding, ticks);
    }

    @Override
    public void holdKeyFor(class_3675.class_306 key, int ticks) {
        ThreadingImpl.checkOnGametestThread("holdKeyFor");
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkArgument((ticks > 0 ? 1 : 0) != 0, (Object)"ticks must be positive");
        this.holdKey(key);
        this.context.waitTicks(ticks);
        this.releaseKey(key);
    }

    @Override
    public void holdKeyFor(int keyCode, int ticks) {
        ThreadingImpl.checkOnGametestThread("holdKeyFor");
        Preconditions.checkArgument((ticks > 0 ? 1 : 0) != 0, (Object)"ticks must be positive");
        this.holdKeyFor(class_3675.class_307.field_1668.method_1447(keyCode), ticks);
    }

    @Override
    public void holdMouseFor(int button, int ticks) {
        ThreadingImpl.checkOnGametestThread("holdMouseFor");
        Preconditions.checkArgument((ticks > 0 ? 1 : 0) != 0, (Object)"ticks must be positive");
        this.holdKeyFor(class_3675.class_307.field_1672.method_1447(button), ticks);
    }

    @Override
    public void typeChar(int codePoint) {
        ThreadingImpl.checkOnGametestThread("typeChar");
        this.context.runOnClient(client -> ((KeyboardAccessor)client.field_1774).invokeOnChar(client.method_22683().method_4490(), codePoint, 0));
    }

    @Override
    public void typeChars(String chars) {
        ThreadingImpl.checkOnGametestThread("typeChars");
        this.context.runOnClient(client -> chars.chars().forEach(codePoint -> ((KeyboardAccessor)client.field_1774).invokeOnChar(client.method_22683().method_4490(), codePoint, 0)));
    }

    @Override
    public void scroll(double amount) {
        ThreadingImpl.checkOnGametestThread("scroll");
        this.scroll(0.0, amount);
    }

    @Override
    public void scroll(double xAmount, double yAmount) {
        ThreadingImpl.checkOnGametestThread("scroll");
        this.context.runOnClient(client -> ((MouseAccessor)client.field_1729).invokeOnMouseScroll(client.method_22683().method_4490(), xAmount, yAmount));
    }

    @Override
    public void setCursorPos(double x, double y) {
        ThreadingImpl.checkOnGametestThread("setCursorPos");
        this.context.runOnClient(client -> ((MouseAccessor)client.field_1729).invokeOnCursorPos(client.method_22683().method_4490(), x, y));
    }

    @Override
    public void moveCursor(double deltaX, double deltaY) {
        ThreadingImpl.checkOnGametestThread("moveCursor");
        this.context.runOnClient(client -> {
            double newX = client.field_1729.method_1603() + deltaX;
            double newY = client.field_1729.method_1604() + deltaY;
            ((MouseAccessor)client.field_1729).invokeOnCursorPos(client.method_22683().method_4490(), newX, newY);
        });
    }

    private static class_3675.class_306 getBoundKey(class_304 keyBinding, String action) {
        class_3675.class_306 boundKey = ((KeyBindingAccessor)keyBinding).getBoundKey();
        if (boundKey == class_3675.field_16237) {
            throw new AssertionError((Object)"Cannot %s binding '%s' because it isn't bound to a key".formatted(action, keyBinding.method_1431()));
        }
        return boundKey;
    }
}

