/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.gametest;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.gametest.ThreadingImpl;
import net.minecraft.class_3176;
import net.minecraft.server.Main;

@Environment(value=EnvType.CLIENT)
public class TestDedicatedServer
implements Closeable {
    public static final AtomicReference<class_3176> DEDICATED_SERVER_REF = new AtomicReference();
    private static final Duration START_TIMEOUT = Duration.ofMinutes(5L);
    final ExecutorService executor = Executors.newSingleThreadExecutor();
    class_3176 server;

    public TestDedicatedServer() {
        assert (DEDICATED_SERVER_REF.get() == null) : "A dedicated server is already running";
        this.executor.execute(this::run);
        this.waitUntilReady();
        Objects.requireNonNull(this.server);
    }

    public String getConnectionAddress() {
        return "localhost:" + this.server.method_3756();
    }

    public void runCommand(String command) {
        ThreadingImpl.runOnServer(() -> this.server.method_3734().method_44252(this.server.method_3739(), command));
    }

    private void run() {
        this.setupServer();
        Main.main((String[])new String[0]);
    }

    private void setupServer() {
        try {
            Files.writeString(Paths.get("eula.txt", new String[0]), (CharSequence)"eula=true", new OpenOption[0]);
            Files.writeString(Paths.get("server.properties", new String[0]), (CharSequence)"online-mode=false", new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void waitUntilReady() {
        long startTime = System.currentTimeMillis();
        while (DEDICATED_SERVER_REF.get() == null) {
            if (System.currentTimeMillis() - startTime > START_TIMEOUT.toMillis()) {
                throw new RuntimeException("Timeout while waiting for the server to start");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.server = DEDICATED_SERVER_REF.get();
        DEDICATED_SERVER_REF.set(null);
    }

    @Override
    public void close() {
        this.server.method_3747(false);
        while (this.server.method_3777().isAlive()) {
            ThreadingImpl.runTick();
        }
        this.executor.close();
    }
}

