/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.gametest;

import com.google.common.base.Preconditions;
import java.util.concurrent.Phaser;
import java.util.concurrent.Semaphore;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.lang3.function.FailableRunnable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public final class ThreadingImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-client-gametest-api-v1");
    public static final int PHASE_TICK = 0;
    public static final int PHASE_SERVER_TASKS = 1;
    public static final int PHASE_CLIENT_TASKS = 2;
    public static final int PHASE_TEST = 3;
    private static final int PHASE_MASK = 3;
    public static final Phaser PHASER = new Phaser();
    public static volatile boolean isClientRunning = false;
    public static volatile boolean clientCanAcceptTasks = false;
    public static final Semaphore CLIENT_SEMAPHORE = new Semaphore(0);
    public static volatile boolean isServerRunning = false;
    public static volatile boolean serverCanAcceptTasks = false;
    public static final Semaphore SERVER_SEMAPHORE = new Semaphore(0);
    @Nullable
    public static Thread testThread = null;
    public static final Semaphore TEST_SEMAPHORE = new Semaphore(0);
    @Nullable
    public static Runnable taskToRun = null;

    private ThreadingImpl() {
    }

    public static void enterPhase(int phase) {
        while ((PHASER.getPhase() & 3) != phase) {
            PHASER.arriveAndAwaitAdvance();
        }
        PHASER.arriveAndAwaitAdvance();
    }

    public static void runTestThread(Runnable test) {
        Preconditions.checkState((testThread == null ? 1 : 0) != 0, (Object)"There is already a test thread running");
        testThread = new Thread(() -> {
            PHASER.register();
            ThreadingImpl.enterPhase(3);
            try {
                test.run();
            }
            catch (Throwable e) {
                LOGGER.error("Failed to run client gametests", e);
                System.exit(1);
            }
            finally {
                PHASER.arriveAndDeregister();
                if (clientCanAcceptTasks) {
                    CLIENT_SEMAPHORE.release();
                }
                if (serverCanAcceptTasks) {
                    SERVER_SEMAPHORE.release();
                }
                testThread = null;
            }
        });
        testThread.setName("Test thread");
        testThread.start();
    }

    public static void checkOnGametestThread(String methodName) {
        Preconditions.checkState((Thread.currentThread() == testThread ? 1 : 0) != 0, (String)"%s can only be called from the client gametest thread", (Object)methodName);
    }

    public static <E extends Throwable> void runOnClient(FailableRunnable<E> action) throws E {
        Preconditions.checkNotNull(action, (Object)"action");
        ThreadingImpl.checkOnGametestThread("runOnClient");
        Preconditions.checkState((boolean)clientCanAcceptTasks, (Object)"runOnClient called when no client is running");
        MutableObject thrown = new MutableObject();
        taskToRun = () -> {
            try {
                action.run();
            }
            catch (Throwable e) {
                thrown.setValue((Object)e);
            }
            finally {
                taskToRun = null;
                TEST_SEMAPHORE.release();
            }
        };
        CLIENT_SEMAPHORE.release();
        try {
            TEST_SEMAPHORE.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (thrown.getValue() != null) {
            throw (Throwable)thrown.getValue();
        }
    }

    public static <E extends Throwable> void runOnServer(FailableRunnable<E> action) throws E {
        Preconditions.checkNotNull(action, (Object)"action");
        ThreadingImpl.checkOnGametestThread("runOnServer");
        Preconditions.checkState((boolean)serverCanAcceptTasks, (Object)"runOnServer called when no server is running");
        MutableObject thrown = new MutableObject();
        taskToRun = () -> {
            try {
                action.run();
            }
            catch (Throwable e) {
                thrown.setValue((Object)e);
            }
            finally {
                taskToRun = null;
                TEST_SEMAPHORE.release();
            }
        };
        SERVER_SEMAPHORE.release();
        try {
            TEST_SEMAPHORE.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (thrown.getValue() != null) {
            throw (Throwable)thrown.getValue();
        }
    }

    public static void runTick() {
        ThreadingImpl.checkOnGametestThread("runTick");
        if (clientCanAcceptTasks) {
            CLIENT_SEMAPHORE.release();
        }
        if (serverCanAcceptTasks) {
            SERVER_SEMAPHORE.release();
        }
        ThreadingImpl.enterPhase(3);
    }
}

