/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.gametest;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.gametest.v1.ClientGameTestContext;
import net.fabricmc.fabric.api.client.gametest.v1.FabricClientGameTest;
import net.fabricmc.fabric.impl.client.gametest.ClientGameTestContextImpl;
import net.fabricmc.fabric.impl.client.gametest.ThreadingImpl;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import net.minecraft.class_442;

@Environment(value=EnvType.CLIENT)
public class FabricClientGameTestRunner {
    private static final String ENTRYPOINT_KEY = "fabric-client-gametest";

    public static void start() {
        class_310.method_1551().method_15995(true);
        List gameTests = FabricLoader.getInstance().getEntrypoints(ENTRYPOINT_KEY, FabricClientGameTest.class);
        ThreadingImpl.runTestThread(() -> {
            ClientGameTestContextImpl context = new ClientGameTestContextImpl();
            for (FabricClientGameTest gameTest : gameTests) {
                context.restoreDefaultGameOptions();
                gameTest.runTest(context);
                context.getInput().clearKeysDown();
                FabricClientGameTestRunner.checkFinalGameTestState(context, gameTest.getClass().getName());
            }
        });
    }

    private static void checkFinalGameTestState(ClientGameTestContext context, String testClassName) {
        if (ThreadingImpl.isServerRunning) {
            throw new AssertionError((Object)"Client gametest %s finished while a server is still running".formatted(testClassName));
        }
        context.runOnClient(client -> {
            if (client.field_1687 != null) {
                throw new AssertionError((Object)"Client gametest %s finished while still connected to a server".formatted(testClassName));
            }
            if (!(client.field_1755 instanceof class_442)) {
                throw new AssertionError((Object)"Client gametest %s did not finish on the title screen".formatted(testClassName));
            }
        });
    }
}

