/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.gametest;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.gametest.v1.TestScreenshotOptions;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

@Environment(value=EnvType.CLIENT)
public class TestScreenshotOptionsImpl
implements TestScreenshotOptions {
    public final String name;
    public boolean counterPrefix = true;
    public float tickDelta = 1.0f;
    @Nullable
    public Vector2i size;
    @Nullable
    public Path destinationDir;

    public TestScreenshotOptionsImpl(String name) {
        this.name = name;
    }

    @Override
    public TestScreenshotOptions disableCounterPrefix() {
        this.counterPrefix = false;
        return this;
    }

    @Override
    public TestScreenshotOptions withTickDelta(float tickDelta) {
        Preconditions.checkArgument((tickDelta >= 0.0f && tickDelta <= 1.0f ? 1 : 0) != 0, (Object)"tickDelta must be between 0 and 1");
        this.tickDelta = tickDelta;
        return this;
    }

    @Override
    public TestScreenshotOptions withSize(int width, int height) {
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0, (Object)"width must be positive");
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0, (Object)"height must be positive");
        this.size = new Vector2i(width, height);
        return this;
    }

    @Override
    public TestScreenshotOptions withDestinationDir(Path destinationDir) {
        Preconditions.checkNotNull((Object)destinationDir, (Object)"destinationDir");
        this.destinationDir = destinationDir;
        return this;
    }
}

