/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.gametest;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.gametest.v1.ClientGameTestContext;
import net.fabricmc.fabric.api.client.gametest.v1.FabricClientGameTest;
import net.fabricmc.fabric.impl.client.gametest.ClientGameTestContextImpl;
import net.fabricmc.fabric.impl.client.gametest.ThreadingImpl;
import net.fabricmc.fabric.impl.client.gametest.WindowHooks;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import net.minecraft.class_442;

@Environment(value=EnvType.CLIENT)
public class FabricClientGameTestRunner {
    private static final String ENTRYPOINT_KEY = "fabric-client-gametest";

    public static void start() {
        class_310.method_1551().method_15995(true);
        List gameTests = FabricLoader.getInstance().getEntrypoints(ENTRYPOINT_KEY, FabricClientGameTest.class);
        ThreadingImpl.runTestThread(() -> {
            ClientGameTestContextImpl context = new ClientGameTestContextImpl();
            for (FabricClientGameTest gameTest : gameTests) {
                FabricClientGameTestRunner.setupInitialGameTestState(context);
                gameTest.runTest(context);
                FabricClientGameTestRunner.setupAndCheckFinalGameTestState(context, gameTest.getClass().getName());
            }
        });
    }

    private static void setupInitialGameTestState(ClientGameTestContext context) {
        context.restoreDefaultGameOptions();
    }

    private static void setupAndCheckFinalGameTestState(ClientGameTestContextImpl context, String testClassName) {
        context.getInput().clearKeysDown();
        context.runOnClient(client -> ((WindowHooks)client.method_22683()).fabric_resetSize());
        context.getInput().setCursorPos((double)((Integer)context.computeOnClient(client -> client.method_22683().method_4480())).intValue() * 0.5, (double)((Integer)context.computeOnClient(client -> client.method_22683().method_4507())).intValue() * 0.5);
        if (ThreadingImpl.isServerRunning) {
            throw new AssertionError((Object)"Client gametest %s finished while a server is still running".formatted(testClassName));
        }
        context.runOnClient(client -> {
            if (client.field_1687 != null) {
                throw new AssertionError((Object)"Client gametest %s finished while still connected to a server".formatted(testClassName));
            }
            if (!(client.field_1755 instanceof class_442)) {
                throw new AssertionError((Object)"Client gametest %s did not finish on the title screen".formatted(testClassName));
            }
        });
    }
}

