/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.gametest;

import com.google.common.base.Preconditions;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.gametest.FabricClientGameTestRunner;
import net.fabricmc.fabric.impl.client.gametest.NetworkSynchronizer;
import net.fabricmc.fabric.impl.client.gametest.ThreadingImpl;
import net.fabricmc.fabric.impl.client.gametest.WindowHooks;
import net.minecraft.class_1041;
import net.minecraft.class_1255;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_3283;
import net.minecraft.class_4071;
import net.minecraft.class_437;
import net.minecraft.class_6904;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_310.class})
public class MinecraftClientMixin {
    @Unique
    private boolean startedClientGametests = false;
    @Unique
    private boolean inMergedRunTasksLoop = false;
    @Unique
    private Runnable deferredTask = null;
    @Shadow
    @Nullable
    private class_4071 field_18175;
    @Shadow
    @Final
    private class_1041 field_1704;

    @WrapMethod(method={"run"})
    private void onRun(Operation<Void> original) throws Throwable {
        if (ThreadingImpl.isClientRunning) {
            throw new IllegalStateException("Client is already running");
        }
        ThreadingImpl.isClientRunning = true;
        ThreadingImpl.PHASER.register();
        try {
            original.call(new Object[0]);
        }
        finally {
            MinecraftClientMixin.deregisterClient();
            if (ThreadingImpl.testFailureException != null) {
                throw ThreadingImpl.testFailureException;
            }
        }
    }

    @Inject(method={"cleanUpAfterCrash"}, at={@At(value="HEAD")})
    private void deregisterAfterCrash(CallbackInfo ci) {
        ThreadingImpl.setGameCrashed();
        MinecraftClientMixin.deregisterClient();
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (!this.startedClientGametests && this.field_18175 == null) {
            this.startedClientGametests = true;
            FabricClientGameTestRunner.start();
        }
    }

    @ModifyExpressionValue(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/RenderTickCounter$Dynamic;beginRenderTick(JZ)I")})
    private int captureTicksPerFrame(int capturedTicksPerFrame, @Share(value="ticksPerFrame") LocalIntRef ticksPerFrame) {
        if (capturedTicksPerFrame > 1) {
            capturedTicksPerFrame = 1;
        }
        ticksPerFrame.set(capturedTicksPerFrame);
        return capturedTicksPerFrame;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;runTasks()V")})
    private void preRunTasksHook(CallbackInfo ci) {
        if (!this.inMergedRunTasksLoop) {
            this.inMergedRunTasksLoop = true;
            this.preRunTasks();
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;runTasks()V", shift=At.Shift.AFTER)})
    private void postRunTasksHook(CallbackInfo ci, @Share(value="ticksPerFrame") LocalIntRef ticksPerFrame) {
        if (ticksPerFrame.get() > 0) {
            NetworkSynchronizer.CLIENTBOUND.waitForPacketHandlers((class_1255)this);
            this.postRunTasks();
            this.inMergedRunTasksLoop = false;
        }
    }

    @Inject(method={"startIntegratedServer"}, at={@At(value="HEAD")}, cancellable=true)
    private void deferStartIntegratedServer(class_32.class_5143 session, class_3283 dataPackManager, class_6904 saveLoader, boolean newWorld, CallbackInfo ci) {
        if (ThreadingImpl.taskToRun != null) {
            this.deferredTask = () -> class_310.method_1551().method_29610(session, dataPackManager, saveLoader, newWorld);
            ci.cancel();
        }
    }

    @Inject(method={"startIntegratedServer"}, at={@At(value="INVOKE", target="Ljava/lang/Thread;sleep(J)V", remap=false)})
    private void onStartIntegratedServerBusyWait(CallbackInfo ci) {
        this.preRunTasks();
        this.postRunTasks();
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screen/Screen;Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void deferDisconnect(class_437 disconnectionScreen, boolean transferring, CallbackInfo ci) {
        if (class_310.method_1551().method_1576() != null && ThreadingImpl.taskToRun != null) {
            this.deferredTask = () -> class_310.method_1551().method_18096(disconnectionScreen, transferring);
            ci.cancel();
        }
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screen/Screen;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;cancelTasks()V")})
    private void onDisconnectCancelTasks(CallbackInfo ci) {
        NetworkSynchronizer.CLIENTBOUND.reset();
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screen/Screen;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;render(Z)V", shift=At.Shift.AFTER)})
    private void onDisconnectBusyWait(CallbackInfo ci) {
        this.preRunTasks();
        this.postRunTasks();
    }

    @Unique
    private void preRunTasks() {
        if (ThreadingImpl.getCurrentPhase() == 2) {
            this.postRunTasks();
        }
        if (!NetworkSynchronizer.DISABLED) {
            ThreadingImpl.enterPhase(1);
            ThreadingImpl.enterPhase(2);
        }
    }

    @Unique
    private void postRunTasks() {
        ThreadingImpl.clientCanAcceptTasks = true;
        ThreadingImpl.enterPhase(3);
        if (ThreadingImpl.testThread != null) {
            while (true) {
                try {
                    ThreadingImpl.CLIENT_SEMAPHORE.acquire();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (ThreadingImpl.taskToRun == null) break;
                ThreadingImpl.taskToRun.run();
            }
        }
        ThreadingImpl.enterPhase(0);
        Runnable deferredTask = this.deferredTask;
        this.deferredTask = null;
        if (deferredTask != null) {
            deferredTask.run();
        }
    }

    @Inject(method={"getInstance"}, at={@At(value="HEAD")})
    private static void checkThreadOnGetInstance(CallbackInfoReturnable<class_310> cir) {
        Preconditions.checkState((Thread.currentThread() != ThreadingImpl.testThread ? 1 : 0) != 0, (Object)"MinecraftClient.getInstance() cannot be called from the gametest thread. Try using ClientGameTestContext.runOnClient or ClientGameTestContext.computeOnClient");
    }

    @ModifyExpressionValue(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/util/Window;hasZeroWidthOrHeight()Z")})
    private boolean hasZeroRealWidthOrHeight(boolean original) {
        WindowHooks windowHooks = (WindowHooks)this.field_1704;
        return windowHooks.fabric_getRealFramebufferWidth() == 0 || windowHooks.fabric_getRealFramebufferHeight() == 0;
    }

    @Unique
    private static void deregisterClient() {
        if (ThreadingImpl.isClientRunning) {
            ThreadingImpl.clientCanAcceptTasks = false;
            ThreadingImpl.PHASER.arriveAndDeregister();
            ThreadingImpl.isClientRunning = false;
        }
    }
}

