/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.gametest;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.gametest.WindowHooks;
import net.minecraft.class_1041;
import net.minecraft.class_313;
import net.minecraft.class_319;
import net.minecraft.class_323;
import net.minecraft.class_3678;
import net.minecraft.class_543;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_1041.class})
public abstract class WindowMixin
implements WindowHooks {
    @Shadow
    private int field_5183;
    @Shadow
    private int field_5198;
    @Shadow
    private int field_5175;
    @Shadow
    private int field_5185;
    @Shadow
    private int field_5182;
    @Shadow
    private int field_5197;
    @Shadow
    private int field_5174;
    @Shadow
    private int field_5184;
    @Shadow
    private int field_5181;
    @Shadow
    private int field_5196;
    @Shadow
    private boolean field_5191;
    @Shadow
    @Final
    private class_3678 field_5176;
    @Shadow
    @Final
    private class_323 field_5195;
    @Shadow
    private Optional<class_319> field_5193;
    @Unique
    private int defaultWidth;
    @Unique
    private int defaultHeight;
    @Unique
    private int realWidth;
    @Unique
    private int realHeight;
    @Unique
    private int realFramebufferWidth;
    @Unique
    private int realFramebufferHeight;

    @Shadow
    protected abstract void method_4479();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(class_3678 eventHandler, class_323 monitorTracker, class_543 settings, @Nullable String fullscreenVideoMode, String title, CallbackInfo ci) {
        this.defaultWidth = settings.field_3285;
        this.defaultHeight = settings.field_3284;
        this.realWidth = this.field_5182;
        this.realHeight = this.field_5197;
        this.realFramebufferWidth = this.field_5181;
        this.realFramebufferHeight = this.field_5196;
        this.field_5174 = this.field_5181 = this.defaultWidth;
        this.field_5182 = this.field_5181;
        this.field_5184 = this.field_5196 = this.defaultHeight;
        this.field_5197 = this.field_5196;
    }

    @Inject(method={"onWindowFocusChanged", "onCursorEnterChanged", "onMinimizeChanged"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelEvents(CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(method={"onWindowSizeChanged"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelWindowSizeChanged(long window, int width, int height, CallbackInfo ci) {
        this.realWidth = width;
        this.realHeight = height;
        ci.cancel();
    }

    @Inject(method={"onFramebufferSizeChanged"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelFramebufferSizeChanged(long window, int width, int height, CallbackInfo ci) {
        this.realFramebufferWidth = width;
        this.realFramebufferHeight = height;
        ci.cancel();
    }

    @WrapMethod(method={"updateWindowRegion"})
    private void wrapUpdateWindowRegion(Operation<Void> original) {
        int prevWidth = this.field_5182;
        int prevHeight = this.field_5197;
        int prevWindowedWidth = this.field_5174;
        int prevWindowedHeight = this.field_5184;
        original.call(new Object[0]);
        this.realWidth = this.field_5182;
        this.realHeight = this.field_5197;
        this.field_5182 = prevWidth;
        this.field_5197 = prevHeight;
        this.field_5174 = prevWindowedWidth;
        this.field_5184 = prevWindowedHeight;
    }

    @Inject(method={"setWindowedSize"}, at={@At(value="HEAD")}, cancellable=true)
    private void setWindowedSize(int width, int height, CallbackInfo ci) {
        this.field_5191 = false;
        this.fabric_resize(width, height);
        ci.cancel();
    }

    @Override
    public int fabric_getRealWidth() {
        return this.realWidth;
    }

    @Override
    public int fabric_getRealHeight() {
        return this.realHeight;
    }

    @Override
    public int fabric_getRealFramebufferWidth() {
        return this.realFramebufferWidth;
    }

    @Override
    public int fabric_getRealFramebufferHeight() {
        return this.realFramebufferHeight;
    }

    @Override
    public void fabric_resetSize() {
        this.fabric_resize(this.defaultWidth, this.defaultHeight);
    }

    @Override
    public void fabric_resize(int width, int height) {
        if (width == this.field_5182 && width == this.field_5174 && width == this.field_5181 && height == this.field_5197 && height == this.field_5184 && height == this.field_5196) {
            return;
        }
        class_313 monitor = this.field_5195.method_1681((class_1041)this);
        if (monitor != null) {
            class_319 videoMode = monitor.method_1614(this.field_5193);
            this.field_5183 += (this.field_5174 - width) / 2;
            this.field_5198 += (this.field_5184 - height) / 2;
            if (this.field_5183 + width > monitor.method_1616() + videoMode.method_1668()) {
                this.field_5183 = monitor.method_1616() + videoMode.method_1668() - width;
            }
            if (this.field_5183 < monitor.method_1616()) {
                this.field_5183 = monitor.method_1616();
            }
            if (this.field_5198 + height > monitor.method_1618() + videoMode.method_1669()) {
                this.field_5198 = monitor.method_1618() + videoMode.method_1669() - height;
            }
            if (this.field_5198 < monitor.method_1618()) {
                this.field_5198 = monitor.method_1618();
            }
            this.field_5175 = this.field_5183;
            this.field_5185 = this.field_5198;
        }
        this.field_5174 = this.field_5181 = width;
        this.field_5182 = this.field_5181;
        this.field_5184 = this.field_5196 = height;
        this.field_5197 = this.field_5196;
        this.method_4479();
        this.field_5176.method_15993();
    }
}

