/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.gametest;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.gametest.v1.ClientGameTestContext;
import net.fabricmc.fabric.api.client.gametest.v1.TestDedicatedServerContext;
import net.fabricmc.fabric.api.client.gametest.v1.TestSingleplayerContext;
import net.fabricmc.fabric.api.client.gametest.v1.TestWorldBuilder;
import net.fabricmc.fabric.impl.client.gametest.ClientGameTestImpl;
import net.fabricmc.fabric.impl.client.gametest.DedicatedServerImplUtil;
import net.fabricmc.fabric.impl.client.gametest.TestDedicatedServerContextImpl;
import net.fabricmc.fabric.impl.client.gametest.TestSingleplayerContextImpl;
import net.fabricmc.fabric.impl.client.gametest.TestWorldSaveImpl;
import net.fabricmc.fabric.impl.client.gametest.ThreadingImpl;
import net.fabricmc.fabric.mixin.client.gametest.CreateWorldScreenAccessor;
import net.minecraft.class_1928;
import net.minecraft.class_310;
import net.minecraft.class_3176;
import net.minecraft.class_437;
import net.minecraft.class_525;
import net.minecraft.class_5317;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8100;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class TestWorldBuilderImpl
implements TestWorldBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-client-gametest-api-v1");
    private final ClientGameTestContext context;
    private boolean useConsistentSettings = true;
    private Consumer<class_8100> settingsAdjustor = creator -> {};

    public TestWorldBuilderImpl(ClientGameTestContext context) {
        this.context = context;
    }

    @Override
    public TestWorldBuilder setUseConsistentSettings(boolean useConsistentSettings) {
        this.useConsistentSettings = useConsistentSettings;
        return this;
    }

    @Override
    public TestWorldBuilder adjustSettings(Consumer<class_8100> settingsAdjuster) {
        Preconditions.checkNotNull(settingsAdjuster, (Object)"settingsAdjuster");
        this.settingsAdjustor = settingsAdjuster;
        return this;
    }

    @Override
    public TestSingleplayerContext create() {
        ThreadingImpl.checkOnGametestThread("create");
        Preconditions.checkState((!ThreadingImpl.isServerRunning ? 1 : 0) != 0, (Object)"Cannot create a world when a server is running");
        Path saveDirectory = this.navigateCreateWorldScreen();
        ClientGameTestImpl.waitForWorldLoad(this.context);
        MinecraftServer server = (MinecraftServer)this.context.computeOnClient(class_310::method_1576);
        return new TestSingleplayerContextImpl(this.context, new TestWorldSaveImpl(this.context, saveDirectory), server);
    }

    @Override
    public TestDedicatedServerContext createServer(Properties serverProperties) {
        ThreadingImpl.checkOnGametestThread("createServer");
        Preconditions.checkState((!ThreadingImpl.isServerRunning ? 1 : 0) != 0, (Object)"Cannot create a server when a server is running");
        DedicatedServerImplUtil.saveLevelDataTo = Path.of(serverProperties.getProperty("level-name", "world"), new String[0]);
        try {
            FileUtils.deleteDirectory((File)DedicatedServerImplUtil.saveLevelDataTo.toFile());
        }
        catch (IOException e) {
            LOGGER.error("Failed to clean up old dedicated server world", (Throwable)e);
        }
        try {
            this.navigateCreateWorldScreen();
        }
        finally {
            DedicatedServerImplUtil.saveLevelDataTo = null;
        }
        class_3176 server = DedicatedServerImplUtil.start(this.context, serverProperties);
        return new TestDedicatedServerContextImpl(this.context, server);
    }

    private Path navigateCreateWorldScreen() {
        Path saveDirectory = (Path)this.context.computeOnClient(client -> {
            class_525.method_31130((class_310)client, (class_437)client.field_1755);
            class_437 patt0$temp = client.field_1755;
            if (!(patt0$temp instanceof class_525)) {
                throw new AssertionError((Object)"CreateWorldScreen.show did not set the current screen");
            }
            class_525 createWorldScreen = (class_525)patt0$temp;
            class_8100 creator = ((CreateWorldScreenAccessor)createWorldScreen).getWorldCreator();
            if (this.useConsistentSettings) {
                TestWorldBuilderImpl.setConsistentSettings(creator);
            }
            this.settingsAdjustor.accept(creator);
            return client.method_1586().method_19636().resolve(creator.method_49703());
        });
        this.context.clickScreenButton("selectWorld.create");
        return saveDirectory;
    }

    private static void setConsistentSettings(class_8100 creator) {
        class_6880.class_6883 flatPreset = creator.method_48728().method_45689().method_30530(class_7924.field_41250).method_46747(class_5317.field_25054);
        creator.method_48705(new class_8100.class_8101((class_6880)flatPreset));
        creator.method_48716("1");
        creator.method_48717(false);
        ((class_1928.class_4310)creator.method_48734().method_20746(class_1928.field_19396)).method_20758(false, null);
        ((class_1928.class_4310)creator.method_48734().method_20746(class_1928.field_19406)).method_20758(false, null);
        ((class_1928.class_4310)creator.method_48734().method_20746(class_1928.field_19390)).method_20758(false, null);
    }
}

