/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.gametest;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.stream.IntStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.gametest.v1.TestScreenshotComparisonAlgorithm;
import net.fabricmc.fabric.impl.client.gametest.NativeImageHooks;
import net.minecraft.class_1011;
import net.minecraft.class_3532;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

@Environment(value=EnvType.CLIENT)
public class TestScreenshotComparisonAlgorithms {
    @Nullable
    private static Vector2i find(TestScreenshotComparisonAlgorithm.RawImage<?> haystack, TestScreenshotComparisonAlgorithm.RawImage<?> needle, PositionPredicate predicate) {
        if (needle.width() > haystack.width() || needle.height() > haystack.height()) {
            return null;
        }
        return IntStream.rangeClosed(0, haystack.height() - needle.height()).parallel().mapToObj(needleY -> {
            int maxNeedleX = haystack.width() - needle.width();
            for (int needleX = 0; needleX <= maxNeedleX; ++needleX) {
                if (!predicate.isAt(needleX, needleY)) continue;
                return new Vector2i(needleX, needleY);
            }
            return null;
        }).filter(Objects::nonNull).findAny().orElse(null);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    private static interface PositionPredicate {
        public boolean isAt(int var1, int var2);
    }

    @Environment(value=EnvType.CLIENT)
    public record RawImageImpl<DATA>(int width, int height, DATA data) implements TestScreenshotComparisonAlgorithm.RawImage<DATA>
    {
        public static TestScreenshotComparisonAlgorithm.RawImage<int[]> toColor(TestScreenshotComparisonAlgorithm.RawImage<byte[]> grayscaleImage) {
            byte[] grayscale = grayscaleImage.data();
            int[] color = new int[grayscale.length];
            for (int i = 0; i < grayscale.length; ++i) {
                int luminance = grayscale[i] & 0xFF;
                color[i] = luminance << 16 | luminance << 8 | luminance;
            }
            return new RawImageImpl<int[]>(grayscaleImage.width(), grayscaleImage.height(), color);
        }

        public static TestScreenshotComparisonAlgorithm.RawImage<byte[]> fromGrayscaleNativeImage(class_1011 image) {
            return new RawImageImpl<byte[]>(image.method_4307(), image.method_4323(), ((NativeImageHooks)image).fabric_copyPixelsLuminance());
        }

        public static TestScreenshotComparisonAlgorithm.RawImage<int[]> fromColorNativeImage(class_1011 image) {
            return new RawImageImpl<int[]>(image.method_4307(), image.method_4323(), ((NativeImageHooks)image).fabric_copyPixelsRgb());
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Exact implements TestScreenshotComparisonAlgorithm
    {
        INSTANCE;


        @Override
        @Nullable
        public Vector2i findColor(TestScreenshotComparisonAlgorithm.RawImage<int[]> haystack, TestScreenshotComparisonAlgorithm.RawImage<int[]> needle) {
            Preconditions.checkNotNull(haystack, (Object)"haystack");
            Preconditions.checkNotNull(needle, (Object)"needle");
            int[] haystackData = haystack.data();
            int[] needleData = needle.data();
            int haystackWidth = haystack.width();
            int needleWidth = needle.width();
            int needleHeight = needle.height();
            return TestScreenshotComparisonAlgorithms.find(haystack, needle, (needleX, needleY) -> {
                for (int y = 0; y < needleHeight; ++y) {
                    for (int x = 0; x < needleWidth; ++x) {
                        int haystackColor = haystackData[(needleY + y) * haystackWidth + needleX + x];
                        int needleColor = needleData[y * needleWidth + x];
                        if (haystackColor == needleColor) continue;
                        return false;
                    }
                }
                return true;
            });
        }

        @Override
        @Nullable
        public Vector2i findGrayscale(TestScreenshotComparisonAlgorithm.RawImage<byte[]> haystack, TestScreenshotComparisonAlgorithm.RawImage<byte[]> needle) {
            Preconditions.checkNotNull(haystack, (Object)"haystack");
            Preconditions.checkNotNull(needle, (Object)"needle");
            byte[] haystackData = haystack.data();
            byte[] needleData = needle.data();
            int haystackWidth = haystack.width();
            int needleWidth = needle.width();
            int needleHeight = needle.height();
            return TestScreenshotComparisonAlgorithms.find(haystack, needle, (needleX, needleY) -> {
                for (int y = 0; y < needleHeight; ++y) {
                    for (int x = 0; x < needleWidth; ++x) {
                        byte haystackLuminance = haystackData[(needleY + y) * haystackWidth + needleX + x];
                        byte needleLuminance = needleData[y * needleWidth + x];
                        if (haystackLuminance == needleLuminance) continue;
                        return false;
                    }
                }
                return true;
            });
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record MeanSquaredDifference(float maxMeanSquaredDifference) implements TestScreenshotComparisonAlgorithm
    {
        public static final MeanSquaredDifference DEFAULT = new MeanSquaredDifference(0.005f);

        @Override
        @Nullable
        public Vector2i findColor(TestScreenshotComparisonAlgorithm.RawImage<int[]> haystack, TestScreenshotComparisonAlgorithm.RawImage<int[]> needle) {
            Preconditions.checkNotNull(haystack, (Object)"haystack");
            Preconditions.checkNotNull(needle, (Object)"needle");
            int[] haystackData = haystack.data();
            int[] needleData = needle.data();
            int haystackWidth = haystack.width();
            int needleWidth = needle.width();
            int needleHeight = needle.height();
            long threshold = (long)((double)this.maxMeanSquaredDifference * (double)needleWidth * (double)needleHeight * 3.0 * 255.0 * 255.0);
            return TestScreenshotComparisonAlgorithms.find(haystack, needle, (needleX, needleY) -> {
                long sumSquaredDifference = 0L;
                for (int y = 0; y < needleHeight; ++y) {
                    for (int x = 0; x < needleWidth; ++x) {
                        int haystackColor = haystackData[(needleY + y) * haystackWidth + needleX + x];
                        int haystackRed = class_9848.method_61327((int)haystackColor);
                        int haystackGreen = class_9848.method_61329((int)haystackColor);
                        int haystackBlue = class_9848.method_61331((int)haystackColor);
                        int needleColor = needleData[y * needleWidth + x];
                        int needleRed = class_9848.method_61327((int)needleColor);
                        int needleGreen = class_9848.method_61329((int)needleColor);
                        int needleBlue = class_9848.method_61331((int)needleColor);
                        if ((sumSquaredDifference += (long)(class_3532.method_34954((int)(haystackRed - needleRed)) + class_3532.method_34954((int)(haystackGreen - needleGreen)) + class_3532.method_34954((int)(haystackBlue - needleBlue)))) < threshold) continue;
                        return false;
                    }
                }
                return true;
            });
        }

        @Override
        @Nullable
        public Vector2i findGrayscale(TestScreenshotComparisonAlgorithm.RawImage<byte[]> haystack, TestScreenshotComparisonAlgorithm.RawImage<byte[]> needle) {
            Preconditions.checkNotNull(haystack, (Object)"haystack");
            Preconditions.checkNotNull(needle, (Object)"needle");
            byte[] haystackData = haystack.data();
            byte[] needleData = needle.data();
            int haystackWidth = haystack.width();
            int needleWidth = needle.width();
            int needleHeight = needle.height();
            long threshold = (long)((double)this.maxMeanSquaredDifference * (double)needleWidth * (double)needleHeight * 255.0 * 255.0);
            return TestScreenshotComparisonAlgorithms.find(haystack, needle, (needleX, needleY) -> {
                long sumSquaredDifference = 0L;
                for (int y = 0; y < needleHeight; ++y) {
                    for (int x = 0; x < needleWidth; ++x) {
                        int haystackLuminance = haystackData[(needleY + y) * haystackWidth + needleX + x] & 0xFF;
                        int needleLuminance = needleData[y * needleWidth + x] & 0xFF;
                        if ((sumSquaredDifference += (long)class_3532.method_34954((int)(haystackLuminance - needleLuminance))) < threshold) continue;
                        return false;
                    }
                }
                return true;
            });
        }
    }
}

