/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.gametest.screenshot;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Either;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.gametest.v1.screenshot.TestScreenshotComparisonAlgorithm;
import net.fabricmc.fabric.api.client.gametest.v1.screenshot.TestScreenshotComparisonOptions;
import net.fabricmc.fabric.impl.client.gametest.FabricClientGameTestRunner;
import net.fabricmc.fabric.impl.client.gametest.screenshot.NativeImageHooks;
import net.fabricmc.fabric.impl.client.gametest.screenshot.TestScreenshotCommonOptionsImpl;
import net.fabricmc.fabric.impl.client.gametest.screenshot.TestScreenshotComparisonAlgorithms;
import net.minecraft.class_1011;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class TestScreenshotComparisonOptionsImpl
extends TestScreenshotCommonOptionsImpl<TestScreenshotComparisonOptions>
implements TestScreenshotComparisonOptions {
    private final Either<String, class_1011> templateImage;
    @Nullable
    public String savedFileName;
    public TestScreenshotComparisonAlgorithm algorithm = TestScreenshotComparisonAlgorithm.defaultAlgorithm();
    public boolean grayscale = false;
    @Nullable
    public class_768 region;

    public TestScreenshotComparisonOptionsImpl(String templateImage) {
        this.templateImage = Either.left((Object)templateImage);
    }

    public TestScreenshotComparisonOptionsImpl(class_1011 templateImage) {
        this.templateImage = Either.right((Object)templateImage);
    }

    @Override
    public TestScreenshotComparisonOptions save() {
        return this.saveWithFileName(this.getTemplateImagePath());
    }

    @Override
    public TestScreenshotComparisonOptions saveWithFileName(String fileName) {
        Preconditions.checkNotNull((Object)fileName, (Object)"fileName");
        this.savedFileName = fileName;
        return this;
    }

    @Override
    public TestScreenshotComparisonOptions withAlgorithm(TestScreenshotComparisonAlgorithm algorithm) {
        Preconditions.checkNotNull((Object)algorithm, (Object)"algorithm");
        this.algorithm = algorithm;
        return this;
    }

    @Override
    public TestScreenshotComparisonOptions withGrayscale() {
        this.grayscale = true;
        return this;
    }

    @Override
    public TestScreenshotComparisonOptions withRegion(int x, int y, int width, int height) {
        Preconditions.checkArgument((x >= 0 ? 1 : 0) != 0, (Object)"x cannot be negative");
        Preconditions.checkArgument((y >= 0 ? 1 : 0) != 0, (Object)"y cannot be negative");
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0, (Object)"width must be positive");
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0, (Object)"height must be positive");
        this.region = new class_768(x, y, width, height);
        return this;
    }

    public String getTemplateImagePath() {
        return (String)this.templateImage.left().orElseThrow();
    }

    @Nullable
    public TestScreenshotComparisonAlgorithm.RawImage<byte[]> getGrayscaleTemplateImage() {
        return (TestScreenshotComparisonAlgorithm.RawImage)this.templateImage.map(fileName -> {
            try (class_1011 image = TestScreenshotComparisonOptionsImpl.loadNativeImage(fileName);){
                if (image == null) {
                    TestScreenshotComparisonAlgorithm.RawImage rawImage = null;
                    return rawImage;
                }
                TestScreenshotComparisonAlgorithms.RawImageImpl<byte[]> rawImageImpl = new TestScreenshotComparisonAlgorithms.RawImageImpl<byte[]>(image.method_4307(), image.method_4323(), ((NativeImageHooks)image).fabric_copyPixelsLuminance());
                return rawImageImpl;
            }
        }, image -> {
            TestScreenshotComparisonOptionsImpl.assertNoTransparency(image);
            return TestScreenshotComparisonAlgorithms.RawImageImpl.fromGrayscaleNativeImage(image);
        });
    }

    @Nullable
    public TestScreenshotComparisonAlgorithm.RawImage<int[]> getColorTemplateImage() {
        return (TestScreenshotComparisonAlgorithm.RawImage)this.templateImage.map(fileName -> {
            try (class_1011 image = TestScreenshotComparisonOptionsImpl.loadNativeImage(fileName);){
                if (image == null) {
                    TestScreenshotComparisonAlgorithm.RawImage rawImage = null;
                    return rawImage;
                }
                TestScreenshotComparisonAlgorithms.RawImageImpl<int[]> rawImageImpl = new TestScreenshotComparisonAlgorithms.RawImageImpl<int[]>(image.method_4307(), image.method_4323(), ((NativeImageHooks)image).fabric_copyPixelsRgb());
                return rawImageImpl;
            }
        }, image -> {
            TestScreenshotComparisonOptionsImpl.assertNoTransparency(image);
            return TestScreenshotComparisonAlgorithms.RawImageImpl.fromColorNativeImage(image);
        });
    }

    @Nullable
    private static class_1011 loadNativeImage(String templateImagePath) {
        class_1011 class_10112;
        block9: {
            Path filePath = FabricClientGameTestRunner.currentlyRunningGameTest.getProvider().findPath("templates/" + templateImagePath + ".png").orElse(null);
            if (filePath == null) {
                return null;
            }
            InputStream stream = Files.newInputStream(filePath, new OpenOption[0]);
            try {
                class_1011 image = class_1011.method_4309((InputStream)stream);
                TestScreenshotComparisonOptionsImpl.assertNoTransparency(image);
                class_10112 = image;
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to load template image", e);
                }
            }
            stream.close();
        }
        return class_10112;
    }

    private static void assertNoTransparency(class_1011 image) {
        if (!((NativeImageHooks)image).fabric_isFullyOpaque()) {
            throw new AssertionError((Object)"Template image is partially transparent which is not supported");
        }
    }
}

