/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.gametest.context;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.gametest.v1.context.ClientGameTestContext;
import net.fabricmc.fabric.api.client.gametest.v1.context.TestClientWorldContext;
import net.fabricmc.fabric.impl.client.gametest.threading.ThreadingImpl;
import net.fabricmc.fabric.mixin.client.gametest.ClientChunkManagerAccessor;
import net.fabricmc.fabric.mixin.client.gametest.ClientChunkMapAccessor;
import net.fabricmc.fabric.mixin.client.gametest.ClientWorldAccessor;
import net.minecraft.class_2806;
import net.minecraft.class_310;
import net.minecraft.class_631;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class TestClientWorldContextImpl
implements TestClientWorldContext {
    private final ClientGameTestContext context;

    public TestClientWorldContextImpl(ClientGameTestContext context) {
        this.context = context;
    }

    @Override
    public int waitForChunksDownload(int timeout) {
        ThreadingImpl.checkOnGametestThread("waitForChunksDownload");
        return this.context.waitFor(TestClientWorldContextImpl::areChunksLoaded, timeout);
    }

    @Override
    public int waitForChunksRender(boolean waitForDownload, int timeout) {
        ThreadingImpl.checkOnGametestThread("waitForChunksRender");
        return this.context.waitFor(client -> (!waitForDownload || TestClientWorldContextImpl.areChunksLoaded(client)) && TestClientWorldContextImpl.areChunksRendered(client), timeout);
    }

    private static boolean areChunksLoaded(class_310 client) {
        int viewDistance = client.field_1690.method_38521();
        class_638 world = Objects.requireNonNull(client.field_1687);
        class_631.class_3681 chunks = ((ClientChunkManagerAccessor)world.method_2935()).getChunks();
        ClientChunkMapAccessor chunksAccessor = (ClientChunkMapAccessor)chunks;
        int centerChunkX = chunksAccessor.getCenterChunkX();
        int centerChunkZ = chunksAccessor.getCenterChunkZ();
        for (int dz = -viewDistance; dz <= viewDistance; ++dz) {
            for (int dx = -viewDistance; dx <= viewDistance; ++dx) {
                if (world.method_8402(centerChunkX + dx, centerChunkZ + dz, class_2806.field_12803, false) != null) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean areChunksRendered(class_310 client) {
        class_638 world = Objects.requireNonNull(client.field_1687);
        return ((ClientWorldAccessor)world).getChunkUpdaters().isEmpty() && client.field_1769.method_3281();
    }
}

