/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.gametest.context;

import com.google.common.base.Preconditions;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.gametest.v1.context.TestServerContext;
import net.fabricmc.fabric.impl.client.gametest.threading.ThreadingImpl;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.commons.lang3.mutable.MutableObject;

@Environment(value=EnvType.CLIENT)
public class TestServerContextImpl
implements TestServerContext {
    protected final MinecraftServer server;

    public TestServerContextImpl(MinecraftServer server) {
        this.server = server;
    }

    @Override
    public void runCommand(String command) {
        ThreadingImpl.checkOnGametestThread("runCommand");
        Preconditions.checkNotNull((Object)command, (Object)"command");
        this.runOnServer(server -> server.method_70562().method_68992().method_44252(server.method_70562().method_68953(), command));
    }

    @Override
    public <E extends Throwable> void runOnServer(FailableConsumer<MinecraftServer, E> action) throws E {
        ThreadingImpl.checkOnGametestThread("runOnServer");
        Preconditions.checkNotNull(action, (Object)"action");
        ThreadingImpl.runOnServer(() -> action.accept((Object)this.server));
    }

    @Override
    public <T, E extends Throwable> T computeOnServer(FailableFunction<MinecraftServer, T, E> function) throws E {
        ThreadingImpl.checkOnGametestThread("computeOnServer");
        Preconditions.checkNotNull(function, (Object)"function");
        MutableObject result = new MutableObject();
        ThreadingImpl.runOnServer(() -> result.setValue(function.apply((Object)this.server)));
        return (T)result.getValue();
    }
}

