/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.gametest.threading;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.gametest.TestSystemProperties;
import net.fabricmc.fabric.impl.client.gametest.threading.NetworkSynchronizer;
import net.fabricmc.fabric.impl.client.gametest.threading.ThreadingImpl;
import net.minecraft.class_1255;
import net.minecraft.class_310;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={MinecraftServer.class})
public class MinecraftServerMixin {
    @WrapMethod(method={"method_29741(Lnet/minecraft/class_3283;Lnet/minecraft/class_6904;Lnet/minecraft/server/MinecraftServer$class_11170;Lnet/minecraft/class_3950;)V"})
    private void onRunServer(Operation<Void> original) {
        if (ThreadingImpl.isServerRunning) {
            throw new IllegalStateException("Server is already running");
        }
        ThreadingImpl.isServerRunning = true;
        ThreadingImpl.PHASER.register();
        try {
            original.call(new Object[0]);
        }
        finally {
            this.deregisterServer();
        }
    }

    @Inject(method={"method_29741(Lnet/minecraft/class_3283;Lnet/minecraft/class_6904;Lnet/minecraft/server/MinecraftServer$class_11170;Lnet/minecraft/class_3950;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;method_3744(Lnet/minecraft/class_128;)V", shift=At.Shift.AFTER)})
    protected void onCrash(CallbackInfo ci) {
        if (ThreadingImpl.testFailureException == null) {
            ThreadingImpl.testFailureException = new Throwable("The server crashed");
        }
        class_310.method_1551().method_1592();
        ThreadingImpl.setGameCrashed();
        this.deregisterServer();
    }

    @Inject(method={"method_29741(Lnet/minecraft/class_3283;Lnet/minecraft/class_6904;Lnet/minecraft/server/MinecraftServer$class_11170;Lnet/minecraft/class_3950;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;method_16208()V")})
    private void preRunTasks(CallbackInfo ci) {
        if (!TestSystemProperties.DISABLE_NETWORK_SYNCHRONIZER) {
            ThreadingImpl.enterPhase(1);
        }
    }

    @Inject(method={"method_29741(Lnet/minecraft/class_3283;Lnet/minecraft/class_6904;Lnet/minecraft/server/MinecraftServer$class_11170;Lnet/minecraft/class_3950;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;method_16208()V", shift=At.Shift.AFTER)})
    private void postRunTasks(CallbackInfo ci) {
        NetworkSynchronizer.SERVERBOUND.waitForPacketHandlers((class_1255)this);
        if (!TestSystemProperties.DISABLE_NETWORK_SYNCHRONIZER) {
            ThreadingImpl.enterPhase(2);
        }
        ThreadingImpl.serverCanAcceptTasks = true;
        ThreadingImpl.enterPhase(3);
        if (ThreadingImpl.testThread != null) {
            while (true) {
                try {
                    ThreadingImpl.SERVER_SEMAPHORE.acquire();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (ThreadingImpl.taskToRun == null) break;
                ThreadingImpl.taskToRun.run();
            }
        }
        ThreadingImpl.enterPhase(0);
    }

    @Inject(method={"method_19464(Lnet/minecraft/class_3738;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void alwaysExecuteNetworkTask(CallbackInfoReturnable<Boolean> cir) {
        if (NetworkSynchronizer.SERVERBOUND.isRunningNetworkTasks()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private void deregisterServer() {
        ThreadingImpl.serverCanAcceptTasks = false;
        ThreadingImpl.PHASER.arriveAndDeregister();
        ThreadingImpl.isServerRunning = false;
        if (!ThreadingImpl.isGameCrashed()) {
            NetworkSynchronizer.SERVERBOUND.reset();
        }
    }
}

