/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.client.gametest;

import net.minecraft.class_10160;
import net.minecraft.class_243;
import net.minecraft.class_846;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_10160.class)
public class ChunkRenderTaskSchedulerMixin {
	@Shadow
	private volatile int size;

	@Inject(method = "dequeueNearest", at = @At(value = "INVOKE", target = "Ljava/util/ListIterator;remove()V"))
	private void cancelTask(class_243 pos, CallbackInfoReturnable<class_846.class_851.class_4577> cir) {
		this.size--;
	}
}
