/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.gametest.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.gametest.v1.context.ClientGameTestContext;
import net.fabricmc.fabric.impl.client.gametest.threading.ThreadingImpl;
import net.minecraft.class_156;
import net.minecraft.class_3176;
import net.minecraft.server.Main;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public final class DedicatedServerImplUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-client-gametest-api-v1");
    private static final Properties DEFAULT_SERVER_PROPERTIES = (Properties)class_156.method_654((Object)new Properties(), properties -> {
        properties.setProperty("online-mode", "false");
        properties.setProperty("sync-chunk-writes", String.valueOf(class_156.method_668() == class_156.class_158.field_1133));
        properties.setProperty("spawn-protection", "0");
        properties.setProperty("max-players", "1");
    });
    @Nullable
    public static Path saveLevelDataTo = null;
    @Nullable
    public static CompletableFuture<class_3176> serverFuture = null;

    private DedicatedServerImplUtil() {
    }

    public static class_3176 start(ClientGameTestContext context, Properties serverProperties) {
        class_3176 server;
        DedicatedServerImplUtil.setupServer(serverProperties);
        serverFuture = new CompletableFuture();
        new Thread(() -> Main.main((String[])new String[0])).start();
        try {
            server = serverFuture.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
        finally {
            serverFuture = null;
        }
        context.waitFor(client -> ThreadingImpl.isServerRunning && ThreadingImpl.serverCanAcceptTasks);
        return server;
    }

    private static void setupServer(Properties customServerProperties) {
        Properties serverProperties = new Properties();
        serverProperties.putAll((Map<?, ?>)DEFAULT_SERVER_PROPERTIES);
        serverProperties.putAll((Map<?, ?>)customServerProperties);
        try (BufferedWriter writer = Files.newBufferedWriter(Path.of("server.properties", new String[0]), new OpenOption[0]);){
            serverProperties.store(writer, null);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write server properties", (Throwable)e);
        }
    }
}

