/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.client.gametest.world;

import java.io.IOException;
import java.nio.file.Files;

import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.impl.client.gametest.util.ClientGameTestImpl;
import net.fabricmc.fabric.impl.client.gametest.util.DedicatedServerImplUtil;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_31;
import net.minecraft.class_525;
import net.minecraft.class_7659;
import net.minecraft.class_7780;

@Mixin(class_525.class)
public class CreateWorldScreenMixin {
	@Inject(method = "createLevel", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/integrated/IntegratedServerLoader;tryLoad(Lnet/minecraft/client/MinecraftClient;Lnet/minecraft/client/gui/screen/world/CreateWorldScreen;Lcom/mojang/serialization/Lifecycle;Ljava/lang/Runnable;Z)V"), cancellable = true)
	private void createLevelDataForServers(CallbackInfo ci, @Local class_7780<class_7659> dynamicRegistries, @Local class_31 levelProperties) {
		if (DedicatedServerImplUtil.saveLevelDataTo != null) {
			class_2487 levelDatInner = levelProperties.method_163(dynamicRegistries.method_45926(), null);
			class_2487 levelDat = new class_2487();
			levelDat.method_10566("Data", levelDatInner);

			try {
				Files.createDirectories(DedicatedServerImplUtil.saveLevelDataTo);
				class_2507.method_30614(levelDat, DedicatedServerImplUtil.saveLevelDataTo.resolve("level.dat"));
			} catch (IOException e) {
				ClientGameTestImpl.LOGGER.error("Failed to save dedicated server level data", e);
			}

			ci.cancel();
		}
	}
}
