/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.gametest.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.fabricmc.fabric.api.client.gametest.v1.context.ClientGameTestContext;
import net.minecraft.class_155;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3928;
import net.minecraft.class_405;
import net.minecraft.class_410;
import net.minecraft.class_437;

public final class ClientGameTestImpl {
	public static final Logger LOGGER = LoggerFactory.getLogger("fabric-client-gametest-api-v1");

	private ClientGameTestImpl() {
	}

	public static void waitForWorldLoad(ClientGameTestContext context) {
		for (int i = 0; i < class_155.field_29703; i++) {
			if (context.computeOnClient(client -> isExperimentalWarningScreen(client.field_1755))) {
				context.clickScreenButton("gui.yes");
			}

			if (context.computeOnClient(client -> client.field_1755 instanceof class_405)) {
				context.clickScreenButton("selectWorld.backupJoinSkipButton");
			}

			if (context.computeOnClient(ClientGameTestImpl::isWorldLoadingFinished)) {
				return;
			}

			context.waitTick();
		}

		if (!context.computeOnClient(ClientGameTestImpl::isWorldLoadingFinished)) {
			throw new AssertionError("Timeout loading world");
		}
	}

	private static boolean isExperimentalWarningScreen(class_437 screen) {
		if (!(screen instanceof class_410)) {
			return false;
		}

		if (!(screen.method_25440().method_10851() instanceof class_2588 translatableContents)) {
			return false;
		}

		return "selectWorld.warning.experimental.title".equals(translatableContents.method_11022());
	}

	private static boolean isWorldLoadingFinished(class_310 client) {
		LOGGER.info("World loading finished: {} screen: {}", client.field_1687, client.field_1755);
		return client.field_1687 != null && !(client.field_1755 instanceof class_3928);
	}
}
