/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.command.client;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import net.fabricmc.fabric.api.client.command.v1.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_637;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Mixin(class_637.class)
abstract class ClientCommandSourceMixin implements FabricClientCommandSource {
	@Shadow
	@Final
	private class_310 client;

	@Override
	public void sendFeedback(class_2561 message) {
		client.field_1705.method_1755(class_2556.field_11735, message, class_156.field_25140);
	}

	@Override
	public void sendError(class_2561 message) {
		client.field_1705.method_1755(class_2556.field_11735, new class_2585("").method_10852(message).method_27692(class_124.field_1061), class_156.field_25140);
	}

	@Override
	public class_310 getClient() {
		return client;
	}

	@Override
	public class_746 getPlayer() {
		return client.field_1724;
	}

	@Override
	public class_638 getWorld() {
		return client.field_1687;
	}
}
