/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.content.registry;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2609;
import net.minecraft.class_3494;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FuelRegistryImpl
implements FuelRegistry {
    public static final FuelRegistryImpl INSTANCE = new FuelRegistryImpl();
    private static final Logger LOGGER = LogManager.getLogger();
    private final Object2IntMap<class_1935> itemCookTimes = new Object2IntLinkedOpenHashMap();
    private final Object2IntMap<class_3494<class_1792>> tagCookTimes = new Object2IntLinkedOpenHashMap();

    @Override
    public Integer get(class_1935 item) {
        return (Integer)class_2609.method_11196().get(item.method_8389());
    }

    @Override
    public void add(class_1935 item, Integer cookTime) {
        if (cookTime > Short.MAX_VALUE) {
            LOGGER.warn("Tried to register an overly high cookTime: " + cookTime + " > 32767! (" + item + ")");
        }
        this.itemCookTimes.put((Object)item, cookTime.intValue());
    }

    @Override
    public void add(class_3494<class_1792> tag, Integer cookTime) {
        if (cookTime > Short.MAX_VALUE) {
            LOGGER.warn("Tried to register an overly high cookTime: " + cookTime + " > 32767! (" + tag.method_15143() + ")");
        }
        this.tagCookTimes.put(tag, cookTime.intValue());
    }

    @Override
    public void remove(class_1935 item) {
        this.add(item, (Integer)0);
    }

    @Override
    public void remove(class_3494<class_1792> tag) {
        this.add(tag, (Integer)0);
    }

    @Override
    public void clear(class_1935 item) {
        this.itemCookTimes.removeInt((Object)item);
    }

    @Override
    public void clear(class_3494<class_1792> tag) {
        this.tagCookTimes.removeInt(tag);
    }

    public void apply(Map<class_1792, Integer> map) {
        int time;
        for (class_3494 tag : this.tagCookTimes.keySet()) {
            time = this.tagCookTimes.getInt((Object)tag);
            if (time <= 0) {
                for (class_1792 i : tag.method_15138()) {
                    map.remove(i);
                }
                continue;
            }
            for (class_1792 i : tag.method_15138()) {
                map.put(i, time);
            }
        }
        for (class_1935 item : this.itemCookTimes.keySet()) {
            time = this.itemCookTimes.getInt((Object)item);
            if (time <= 0) {
                map.remove(item.method_8389());
                continue;
            }
            map.put(item.method_8389(), time);
        }
    }
}

