/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.registry;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LandPathNodeTypesRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(LandPathNodeTypesRegistry.class);
    private static final Map<Block, PathNodeTypeProvider> NODE_TYPES = new IdentityHashMap<Block, PathNodeTypeProvider>();

    private LandPathNodeTypesRegistry() {
    }

    public static void register(Block block, @Nullable PathType nodeType, @Nullable PathType nodeTypeIfNeighbor) {
        Objects.requireNonNull(block, "Block cannot be null!");
        LandPathNodeTypesRegistry.register(block, (state, neighbor) -> neighbor ? nodeTypeIfNeighbor : nodeType);
    }

    public static void register(Block block, StaticPathNodeTypeProvider provider) {
        Objects.requireNonNull(block, "Block cannot be null!");
        Objects.requireNonNull(provider, "StaticPathNodeTypeProvider cannot be null!");
        PathNodeTypeProvider old = NODE_TYPES.put(block, provider);
        if (old != null) {
            LOGGER.debug("Replaced PathNodeType provider for the block {}", (Object)block);
        }
    }

    public static void registerDynamic(Block block, DynamicPathNodeTypeProvider provider) {
        Objects.requireNonNull(block, "Block cannot be null!");
        Objects.requireNonNull(provider, "DynamicPathNodeTypeProvider cannot be null!");
        PathNodeTypeProvider old = NODE_TYPES.put(block, provider);
        if (old != null) {
            LOGGER.debug("Replaced PathNodeType provider for the block {}", (Object)block);
        }
    }

    public static @Nullable PathType getPathNodeType(BlockState state, BlockGetter world, BlockPos pos, boolean neighbor) {
        Objects.requireNonNull(state, "BlockState cannot be null!");
        Objects.requireNonNull(world, "BlockView cannot be null!");
        Objects.requireNonNull(pos, "BlockPos cannot be null!");
        PathNodeTypeProvider provider = LandPathNodeTypesRegistry.getPathNodeTypeProvider(state.getBlock());
        if (provider == null) {
            return null;
        }
        if (provider instanceof DynamicPathNodeTypeProvider) {
            return ((DynamicPathNodeTypeProvider)provider).getPathNodeType(state, world, pos, neighbor);
        }
        return ((StaticPathNodeTypeProvider)provider).getPathNodeType(state, neighbor);
    }

    public static @Nullable PathNodeTypeProvider getPathNodeTypeProvider(Block block) {
        Objects.requireNonNull(block, "Block cannot be null!");
        return NODE_TYPES.get(block);
    }

    @FunctionalInterface
    public static non-sealed interface StaticPathNodeTypeProvider
    extends PathNodeTypeProvider {
        public @Nullable PathType getPathNodeType(BlockState var1, boolean var2);
    }

    public static sealed interface PathNodeTypeProvider
    permits StaticPathNodeTypeProvider, DynamicPathNodeTypeProvider {
    }

    @FunctionalInterface
    public static non-sealed interface DynamicPathNodeTypeProvider
    extends PathNodeTypeProvider {
        public @Nullable PathType getPathNodeType(BlockState var1, BlockGetter var2, BlockPos var3, boolean var4);
    }
}

