/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.attachment;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.impl.attachment.AttachmentTargetImpl;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2839;
import net.minecraft.class_2852;
import net.minecraft.class_3218;
import net.minecraft.class_4153;

@Mixin(class_2852.class)
abstract class ChunkSerializerMixin {
	@ModifyExpressionValue(
			at = @At(
					value = "NEW",
					target = "net/minecraft/world/chunk/WorldChunk"
			),
			method = "deserialize"
	)
	private static class_2818 readWorldChunkAttachments(class_2818 chunk, class_3218 world, class_4153 poiStorage, class_1923 chunkPos, class_2487 nbt) {
		((AttachmentTargetImpl) chunk).fabric_readAttachmentsFromNbt(nbt);
		return chunk;
	}

	@ModifyExpressionValue(
			at = @At(
					value = "NEW",
					target = "net/minecraft/world/chunk/ProtoChunk"
			),
			method = "deserialize"
	)
	private static class_2839 readProtoChunkAttachments(class_2839 chunk, class_3218 world, class_4153 poiStorage, class_1923 chunkPos, class_2487 nbt) {
		((AttachmentTargetImpl) chunk).fabric_readAttachmentsFromNbt(nbt);
		return chunk;
	}

	@Inject(
			at = @At("RETURN"),
			method = "serialize"
	)
	private static void writeChunkAttachments(class_3218 world, class_2791 chunk, CallbackInfoReturnable<class_2487> cir) {
		((AttachmentTargetImpl) chunk).fabric_writeAttachmentsToNbt(cir.getReturnValue());
	}
}
