/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.attachment;

import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.impl.attachment.AttachmentEntrypoint;
import net.fabricmc.fabric.impl.attachment.AttachmentSerializingImpl;
import net.fabricmc.fabric.impl.attachment.AttachmentTargetImpl;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={class_2586.class, class_1297.class, class_1937.class, class_2791.class})
abstract class AttachmentTargetsMixin
implements AttachmentTargetImpl {
    @Nullable
    private IdentityHashMap<AttachmentType<?>, Object> fabric_dataAttachments = null;

    AttachmentTargetsMixin() {
    }

    @Nullable
    public <T> T getAttached(AttachmentType<T> type) {
        return (T)(this.fabric_dataAttachments == null ? null : this.fabric_dataAttachments.get(type));
    }

    @Nullable
    public <T> T setAttached(AttachmentType<T> type, @Nullable T value) {
        AttachmentTargetsMixin thisObject = this;
        if (thisObject instanceof class_2586) {
            ((class_2586)thisObject).method_5431();
        } else if (thisObject instanceof class_2791) {
            ((class_2791)thisObject).method_12008(true);
            if (type.isPersistent() && ((class_2791)thisObject).method_12009().equals(class_2806.field_12798)) {
                AttachmentEntrypoint.LOGGER.warn("Attaching persistent attachment {} to chunk with chunk status EMPTY. Attachment might be discarded.", (Object)type.identifier());
            }
        }
        if (value == null) {
            if (this.fabric_dataAttachments == null) {
                return null;
            }
            Object removed = this.fabric_dataAttachments.remove(type);
            if (this.fabric_dataAttachments.isEmpty()) {
                this.fabric_dataAttachments = null;
            }
            return (T)removed;
        }
        if (this.fabric_dataAttachments == null) {
            this.fabric_dataAttachments = new IdentityHashMap();
        }
        return (T)this.fabric_dataAttachments.put(type, value);
    }

    @Override
    public boolean hasAttached(AttachmentType<?> type) {
        return this.fabric_dataAttachments != null && this.fabric_dataAttachments.containsKey(type);
    }

    @Override
    public void fabric_writeAttachmentsToNbt(class_2487 nbt) {
        AttachmentSerializingImpl.serializeAttachmentData(nbt, this.fabric_dataAttachments);
    }

    @Override
    public void fabric_readAttachmentsFromNbt(class_2487 nbt) {
        this.fabric_dataAttachments = AttachmentSerializingImpl.deserializeAttachmentData(nbt);
    }

    @Override
    public boolean fabric_hasPersistentAttachments() {
        return AttachmentSerializingImpl.hasPersistentAttachments(this.fabric_dataAttachments);
    }

    @Override
    public Map<AttachmentType<?>, ?> fabric_getAttachments() {
        return this.fabric_dataAttachments;
    }
}

