/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.attachment;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.impl.attachment.AttachmentRegistryImpl;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentSerializingImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-data-attachment-api-v1");

    public static void serializeAttachmentData(class_2487 nbt, class_7225.class_7874 wrapperLookup, @Nullable IdentityHashMap<AttachmentType<?>, ?> attachments) {
        if (attachments == null) {
            return;
        }
        class_2487 compound = new class_2487();
        for (Map.Entry<AttachmentType<?>, ?> entry : attachments.entrySet()) {
            AttachmentType<?> type = entry.getKey();
            Codec<?> codec = type.persistenceCodec();
            if (codec == null) continue;
            class_6903 registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)wrapperLookup);
            codec.encodeStart((DynamicOps)registryOps, entry.getValue()).get().ifRight(partial -> {
                LOGGER.warn("Couldn't serialize attachment " + String.valueOf(type.identifier()) + ", skipping. Error:");
                LOGGER.warn(partial.message());
            }).ifLeft(serialized -> compound.method_10566(type.identifier().toString(), serialized));
        }
        nbt.method_10566("fabric:attachments", (class_2520)compound);
    }

    public static IdentityHashMap<AttachmentType<?>, Object> deserializeAttachmentData(class_2487 nbt, class_7225.class_7874 wrapperLookup) {
        IdentityHashMap attachments = new IdentityHashMap();
        if (nbt.method_10573("fabric:attachments", 10)) {
            class_2487 compound = nbt.method_10562("fabric:attachments");
            for (String key : compound.method_10541()) {
                AttachmentType<?> type = AttachmentRegistryImpl.get(new class_2960(key));
                if (type == null) {
                    LOGGER.warn("Unknown attachment type " + key + " found when deserializing, skipping");
                    continue;
                }
                Codec<?> codec = type.persistenceCodec();
                if (codec == null) continue;
                class_6903 registryOps = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)wrapperLookup);
                codec.parse((DynamicOps)class_2509.field_11560, (Object)compound.method_10580(key)).get().ifRight(partial -> {
                    LOGGER.warn("Couldn't deserialize attachment " + String.valueOf(type.identifier()) + ", skipping. Error:");
                    LOGGER.warn(partial.message());
                }).ifLeft(deserialized -> attachments.put(type, deserialized));
            }
        }
        return attachments;
    }

    public static boolean hasPersistentAttachments(@Nullable IdentityHashMap<AttachmentType<?>, ?> map) {
        if (map == null) {
            return false;
        }
        for (AttachmentType<?> type : map.keySet()) {
            if (!type.isPersistent()) continue;
            return true;
        }
        return false;
    }
}

