/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.attachment;

import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

/**
 * Backing storage for server-side world attachments.
 * Thanks to custom {@link #method_79()} logic, the file is only written if something needs to be persisted.
 */
public class AttachmentPersistentState extends class_18 {
	public static final String ID = "fabric_attachments";
	private final AttachmentTargetImpl worldTarget;
	private final boolean wasSerialized;

	public AttachmentPersistentState(class_3218 world) {
		this.worldTarget = (AttachmentTargetImpl) world;
		this.wasSerialized = worldTarget.fabric_hasPersistentAttachments();
	}

	public static AttachmentPersistentState read(class_3218 world, @Nullable class_2487 nbt, class_7225.class_7874 wrapperLookup) {
		((AttachmentTargetImpl) world).fabric_readAttachmentsFromNbt(nbt, wrapperLookup);
		return new AttachmentPersistentState(world);
	}

	@Override
	public boolean method_79() {
		// Only write data if there are attachments, or if we previously wrote data.
		return wasSerialized || worldTarget.fabric_hasPersistentAttachments();
	}

	@Override
	public class_2487 method_75(class_2487 nbt, class_7225.class_7874 wrapperLookup) {
		worldTarget.fabric_writeAttachmentsToNbt(nbt, wrapperLookup);
		return nbt;
	}
}
