/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.attachment;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.attachment.v1.AttachmentTarget;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.impl.attachment.AttachmentSerializingImpl;
import net.fabricmc.fabric.impl.attachment.AttachmentTargetImpl;
import net.fabricmc.fabric.impl.attachment.AttachmentTypeImpl;
import net.fabricmc.fabric.impl.attachment.sync.AttachmentChange;
import net.fabricmc.fabric.impl.attachment.sync.s2c.AttachmentSyncPayloadS2C;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_2791;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_2586.class, class_1297.class, class_1937.class, class_2791.class})
abstract class AttachmentTargetsMixin
implements AttachmentTargetImpl {
    @Nullable
    private IdentityHashMap<AttachmentType<?>, Object> fabric_dataAttachments = null;
    @Nullable
    private IdentityHashMap<AttachmentType<?>, AttachmentChange> fabric_syncedAttachments = null;
    @Nullable
    private IdentityHashMap<AttachmentType<?>, Event<AttachmentTarget.OnAttachedSet<?>>> fabric_attachedChangedListeners = null;

    AttachmentTargetsMixin() {
    }

    @Nullable
    public <T> T getAttached(AttachmentType<T> type) {
        return (T)(this.fabric_dataAttachments == null ? null : this.fabric_dataAttachments.get(type));
    }

    @Nullable
    public <T> T setAttached(AttachmentType<T> type, @Nullable T value) {
        Event<AttachmentTarget.OnAttachedSet<?>> event;
        Object oldValue;
        this.fabric_markChanged(type);
        if (this.fabric_shouldTryToSync() && type.isSynced()) {
            AttachmentChange change = AttachmentChange.create(this.fabric_getSyncTargetInfo(), type, value, this.fabric_getDynamicRegistryManager());
            this.acknowledgeSyncedEntry(type, change);
            this.fabric_syncChange(type, new AttachmentSyncPayloadS2C(List.of(change)));
        }
        if (value == null) {
            oldValue = this.fabric_dataAttachments == null ? null : this.fabric_dataAttachments.remove(type);
        } else {
            if (this.fabric_dataAttachments == null) {
                this.fabric_dataAttachments = new IdentityHashMap();
            }
            oldValue = this.fabric_dataAttachments.put(type, value);
        }
        if (this.fabric_attachedChangedListeners != null && (event = this.fabric_attachedChangedListeners.get(type)) != null) {
            ((AttachmentTarget.OnAttachedSet)event.invoker()).onAttachedSet(oldValue, value);
        }
        return (T)oldValue;
    }

    @Override
    public boolean hasAttached(AttachmentType<?> type) {
        return this.fabric_dataAttachments != null && this.fabric_dataAttachments.containsKey(type);
    }

    @Override
    public <A> Event<AttachmentTarget.OnAttachedSet<A>> onAttachedSet(AttachmentType<A> type) {
        if (this.fabric_attachedChangedListeners == null) {
            this.fabric_attachedChangedListeners = new IdentityHashMap();
        }
        return this.fabric_attachedChangedListeners.computeIfAbsent(type, t -> EventFactory.createArrayBacked(AttachmentTarget.OnAttachedSet.class, listeners -> (oldValue, newValue) -> {
            for (AttachmentTarget.OnAttachedSet listener : listeners) {
                listener.onAttachedSet(oldValue, newValue);
            }
        }));
    }

    @Override
    public void fabric_writeAttachmentsToNbt(class_11372 view) {
        AttachmentSerializingImpl.serializeAttachmentData(view, this.fabric_dataAttachments);
    }

    @Override
    public void fabric_readAttachmentsFromNbt(class_11368 view) {
        this.fabric_dataAttachments = AttachmentSerializingImpl.deserializeAttachmentData(view);
        if (this.fabric_shouldTryToSync() && this.fabric_dataAttachments != null) {
            this.fabric_dataAttachments.forEach((type, value) -> {
                if (type.isSynced()) {
                    this.acknowledgeSynced((AttachmentType<?>)type, value, view.method_71414());
                }
            });
        }
    }

    @Override
    public boolean fabric_hasPersistentAttachments() {
        return AttachmentSerializingImpl.hasPersistentAttachments(this.fabric_dataAttachments);
    }

    @Override
    public Map<AttachmentType<?>, ?> fabric_getAttachments() {
        return this.fabric_dataAttachments;
    }

    @Unique
    private void acknowledgeSynced(AttachmentType<?> type, Object value, class_7225.class_7874 wrapperLookup) {
        class_5455 drm;
        class_5455 dynamicRegistryManager = wrapperLookup instanceof class_5455 ? (drm = (class_5455)wrapperLookup) : this.fabric_getDynamicRegistryManager();
        this.acknowledgeSyncedEntry(type, AttachmentChange.create(this.fabric_getSyncTargetInfo(), type, value, dynamicRegistryManager));
    }

    @Unique
    private void acknowledgeSyncedEntry(AttachmentType<?> type, @Nullable AttachmentChange change) {
        if (change == null) {
            if (this.fabric_syncedAttachments == null) {
                return;
            }
            this.fabric_syncedAttachments.remove(type);
        } else {
            if (this.fabric_syncedAttachments == null) {
                this.fabric_syncedAttachments = new IdentityHashMap();
            }
            this.fabric_syncedAttachments.put(type, change);
        }
    }

    @Override
    public void fabric_computeInitialSyncChanges(class_3222 player, Consumer<AttachmentChange> changeOutput) {
        if (this.fabric_syncedAttachments == null) {
            return;
        }
        for (Map.Entry<AttachmentType<?>, AttachmentChange> entry : this.fabric_syncedAttachments.entrySet()) {
            if (!((AttachmentTypeImpl)entry.getKey()).syncPredicate().test(this, player)) continue;
            changeOutput.accept(entry.getValue());
        }
    }
}

