/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.attachment;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.attachment.v1.AttachmentTarget;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.impl.attachment.AttachmentSerializingImpl;
import net.fabricmc.fabric.impl.attachment.AttachmentTargetImpl;
import net.fabricmc.fabric.impl.attachment.AttachmentTypeImpl;
import net.fabricmc.fabric.impl.attachment.sync.AttachmentChange;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BlockEntity.class, Entity.class, Level.class, ChunkAccess.class})
abstract class AttachmentTargetsMixin
implements AttachmentTargetImpl {
    @Unique
    private @Nullable IdentityHashMap<AttachmentType<?>, Object> dataAttachments = null;
    @Unique
    private @Nullable IdentityHashMap<AttachmentType<?>, AttachmentChange> syncedAttachments = null;
    @Unique
    private @Nullable IdentityHashMap<AttachmentType<?>, Event<AttachmentTarget.OnAttachedSet<?>>> attachedChangedListeners = null;

    AttachmentTargetsMixin() {
    }

    public <T> @Nullable T getAttached(AttachmentType<T> type) {
        return (T)(this.dataAttachments == null ? null : this.dataAttachments.get(type));
    }

    public <T> @Nullable T setAttached(AttachmentType<T> type, @Nullable T value) {
        Event<AttachmentTarget.OnAttachedSet<?>> event;
        Object oldValue;
        if (value == null) {
            oldValue = this.dataAttachments == null ? null : this.dataAttachments.remove(type);
        } else {
            if (this.dataAttachments == null) {
                this.dataAttachments = new IdentityHashMap();
            }
            oldValue = this.dataAttachments.put(type, value);
        }
        if (this.attachedChangedListeners != null && (event = this.attachedChangedListeners.get(type)) != null) {
            ((AttachmentTarget.OnAttachedSet)event.invoker()).onAttachedSet(oldValue, value);
        }
        if (!Objects.equals(oldValue, value)) {
            this.fabric_markChanged(type);
            if (this.fabric_shouldTryToSync() && type.isSynced()) {
                AttachmentChange change = AttachmentChange.create(this.fabric_getSyncTargetInfo(), type, value, this.fabric_getDynamicRegistryManager());
                this.acknowledgeSyncedEntry(type, change);
                this.fabric_syncChange(type, change);
            }
        }
        return (T)oldValue;
    }

    @Override
    public boolean hasAttached(AttachmentType<?> type) {
        return this.dataAttachments != null && this.dataAttachments.containsKey(type);
    }

    @Override
    public <A> Event<AttachmentTarget.OnAttachedSet<A>> onAttachedSet(AttachmentType<A> type) {
        if (this.attachedChangedListeners == null) {
            this.attachedChangedListeners = new IdentityHashMap();
        }
        return this.attachedChangedListeners.computeIfAbsent(type, t -> EventFactory.createArrayBacked(AttachmentTarget.OnAttachedSet.class, listeners -> (oldValue, newValue) -> {
            for (AttachmentTarget.OnAttachedSet listener : listeners) {
                listener.onAttachedSet(oldValue, newValue);
            }
        }));
    }

    @Override
    public void fabric_writeAttachmentsToNbt(ValueOutput view) {
        AttachmentSerializingImpl.serializeAttachmentData(view, this.dataAttachments);
    }

    @Override
    public void fabric_readAttachmentsFromNbt(ValueInput view) {
        IdentityHashMap<AttachmentType<?>, Object> fromNbt = AttachmentSerializingImpl.deserializeAttachmentData(view);
        if (fromNbt == null) {
            return;
        }
        this.dataAttachments = fromNbt;
        if (this.fabric_shouldTryToSync() && this.dataAttachments != null) {
            this.dataAttachments.forEach((type, value) -> {
                if (type.isSynced()) {
                    this.acknowledgeSynced((AttachmentType<?>)type, value, view.lookup());
                }
            });
        }
    }

    @Override
    public boolean fabric_hasPersistentAttachments() {
        return AttachmentSerializingImpl.hasPersistentAttachments(this.dataAttachments);
    }

    @Override
    public Map<AttachmentType<?>, ?> fabric_getAttachments() {
        return this.dataAttachments;
    }

    @Unique
    private void acknowledgeSynced(AttachmentType<?> type, Object value, HolderLookup.Provider wrapperLookup) {
        RegistryAccess drm;
        RegistryAccess dynamicRegistryManager = wrapperLookup instanceof RegistryAccess ? (drm = (RegistryAccess)wrapperLookup) : this.fabric_getDynamicRegistryManager();
        this.acknowledgeSyncedEntry(type, AttachmentChange.create(this.fabric_getSyncTargetInfo(), type, value, dynamicRegistryManager));
    }

    @Unique
    private void acknowledgeSyncedEntry(AttachmentType<?> type, @Nullable AttachmentChange change) {
        if (change == null) {
            if (this.syncedAttachments == null) {
                return;
            }
            this.syncedAttachments.remove(type);
        } else {
            if (this.syncedAttachments == null) {
                this.syncedAttachments = new IdentityHashMap();
            }
            this.syncedAttachments.put(type, change);
        }
    }

    @Override
    public void fabric_computeInitialSyncChanges(ServerPlayer player, Consumer<AttachmentChange> changeOutput) {
        if (this.syncedAttachments == null) {
            return;
        }
        for (Map.Entry<AttachmentType<?>, AttachmentChange> entry : this.syncedAttachments.entrySet()) {
            if (!((AttachmentTypeImpl)entry.getKey()).syncPredicate().test(this, player)) continue;
            changeOutput.accept(entry.getValue());
        }
    }
}

