/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.attachment;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import net.fabricmc.fabric.impl.attachment.AttachmentTargetImpl;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentSavedData
extends SavedData {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentSavedData.class);
    public static final Identifier ID = Identifier.fromNamespaceAndPath((String)"fabric", (String)"attachments");
    private final AttachmentTargetImpl levelTarget;
    private final boolean wasSerialized;

    public AttachmentSavedData(ServerLevel level) {
        this.levelTarget = (AttachmentTargetImpl)level;
        this.wasSerialized = this.levelTarget.fabric_hasPersistentAttachments();
    }

    public static Codec<AttachmentSavedData> codec(final ServerLevel level) {
        final ProblemReporter.PathElement reporterContext = () -> "AttachmentSavedData @ " + String.valueOf(level.dimension().identifier());
        return Codec.of((Encoder)new Encoder<AttachmentSavedData>(){

            public <T> DataResult<T> encode(AttachmentSavedData input, DynamicOps<T> ops, T prefix) {
                try (ProblemReporter.ScopedCollector reporter = new ProblemReporter.ScopedCollector(reporterContext, LOGGER);){
                    TagValueOutput output = TagValueOutput.createWithoutContext((ProblemReporter)reporter);
                    ((AttachmentTargetImpl)level).fabric_writeAttachmentsToNbt((ValueOutput)output);
                    DataResult dataResult = DataResult.success((Object)NbtOps.INSTANCE.convertTo(ops, (Tag)output.buildResult()));
                    return dataResult;
                }
            }
        }, (Decoder)new Decoder<AttachmentSavedData>(){

            public <T> DataResult<Pair<AttachmentSavedData, T>> decode(DynamicOps<T> ops, T input) {
                try (ProblemReporter.ScopedCollector reporter = new ProblemReporter.ScopedCollector(reporterContext, LOGGER);){
                    ValueInput valueInput = TagValueInput.create((ProblemReporter)reporter, (HolderLookup.Provider)level.registryAccess(), (CompoundTag)((CompoundTag)ops.convertTo((DynamicOps)NbtOps.INSTANCE, input)));
                    ((AttachmentTargetImpl)level).fabric_readAttachmentsFromNbt(valueInput);
                    DataResult dataResult = DataResult.success((Object)Pair.of((Object)((Object)new AttachmentSavedData(level)), (Object)ops.empty()));
                    return dataResult;
                }
            }
        });
    }

    public boolean isDirty() {
        return this.wasSerialized || this.levelTarget.fabric_hasPersistentAttachments();
    }
}

