/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLootTableProvider;
import net.minecraft.class_173;
import net.minecraft.class_176;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2430;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_52;

public abstract class FabricBlockLootTablesProvider
extends class_2430
implements FabricLootTableProvider {
    protected final FabricDataGenerator dataGenerator;

    protected FabricBlockLootTablesProvider(FabricDataGenerator dataGenerator) {
        this.dataGenerator = dataGenerator;
    }

    protected abstract void generateBlockLootTables();

    @Override
    public class_176 getLootContextType() {
        return class_173.field_1172;
    }

    @Override
    public FabricDataGenerator getFabricDataGenerator() {
        return this.dataGenerator;
    }

    public void method_10379(BiConsumer<class_2960, class_52.class_53> biConsumer) {
        this.generateBlockLootTables();
        for (Map.Entry entry : this.field_16493.entrySet()) {
            class_2960 identifier = (class_2960)entry.getKey();
            if (identifier.equals((Object)class_39.field_844)) continue;
            biConsumer.accept(identifier, (class_52.class_53)entry.getValue());
        }
        if (this.dataGenerator.isStrictValidationEnabled()) {
            HashSet missing = Sets.newHashSet();
            for (class_2960 blockId : class_2378.field_11146.method_10235()) {
                if (!blockId.method_12836().equals(this.dataGenerator.getModId()) || this.field_16493.containsKey(((class_2248)class_2378.field_11146.method_10223(blockId)).method_26162())) continue;
                missing.add(blockId);
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing loot table(s) for %s".formatted(missing));
            }
        }
    }

    public String method_10321() {
        return "Block Loot Tables";
    }
}

