/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.datagen.v1.provider;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import java.util.function.Consumer;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_161;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2960;

/**
 * Extend this class and implement {@link FabricAdvancementsProvider#generateAdvancement}.
 *
 * <p>Register an instance of the class with {@link FabricDataGenerator#addProvider} in a {@link net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint}
 */
public abstract class FabricAdvancementsProvider implements class_2405 {
	private static final Gson GSON = (new GsonBuilder()).setPrettyPrinting().create();

	protected final FabricDataGenerator dataGenerator;

	protected FabricAdvancementsProvider(FabricDataGenerator dataGenerator) {
		this.dataGenerator = dataGenerator;
	}

	/**
	 * Implement this method to register advancements to generate use the consumer callback to register advancements.
	 *
	 * <p>Use {@link class_161.class_162#method_694(Consumer, String)} to help build advancements.
	 */
	public abstract void generateAdvancement(Consumer<class_161> consumer);

	@Override
	public void method_10319(class_2408 cache) throws IOException {
		final Set<class_2960> identifiers = Sets.newHashSet();
		final Set<class_161> advancements = Sets.newHashSet();

		generateAdvancement(advancements::add);

		for (class_161 advancement : advancements) {
			if (!identifiers.add(advancement.method_688())) {
				throw new IllegalStateException("Duplicate advancement " + advancement.method_688());
			}

			class_2405.method_10320(GSON, cache, advancement.method_689().method_698(), getOutputPath(advancement));
		}
	}

	private Path getOutputPath(class_161 advancement) {
		return dataGenerator.method_10313().resolve("data/%s/advancements/%s.json".formatted(advancement.method_688().method_12836(), advancement.method_688().method_12832()));
	}

	@Override
	public String method_10321() {
		return "Advancements";
	}
}
