/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.datagen.v1.provider;

import java.nio.file.Path;
import java.util.Set;
import java.util.function.Consumer;

import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_2408;
import net.minecraft.class_2444;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2960;

/**
 * Extend this class and implement {@link FabricRecipesProvider#generateRecipes}.
 *
 * <p>Register an instance of the class with {@link FabricDataGenerator#addProvider} in a {@link net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint}
 */
public abstract class FabricRecipesProvider extends class_2446 {
	protected final FabricDataGenerator dataGenerator;

	public FabricRecipesProvider(FabricDataGenerator dataGenerator) {
		super(dataGenerator);
		this.dataGenerator = dataGenerator;
	}

	/**
	 * Implement this method and then use the range of methods in {@link class_2446} or from one of the recipe json factories such as {@link class_2447} & {@link class_2450}.
	 */
	protected abstract void generateRecipes(Consumer<class_2444> exporter);

	@Override
	public void method_10319(class_2408 cache) {
		Path path = this.field_11373.method_10313();
		Set<class_2960> generatedRecipes = Sets.newHashSet();
		generateRecipes(provider -> {
			class_2960 identifier = getRecipeIdentifier(provider.method_10417());

			if (!generatedRecipes.add(identifier)) {
				throw new IllegalStateException("Duplicate recipe " + identifier);
			}

			method_10425(cache, provider.method_17799(), path.resolve("data/" + identifier.method_12836() + "/recipes/" + identifier.method_12832() + ".json"));
			JsonObject jsonObject = provider.method_10415();

			if (jsonObject != null) {
				method_10427(cache, jsonObject, path.resolve("data/" + identifier.method_12836() + "/advancements/" + provider.method_10418().method_12832() + ".json"));
			}
		});
	}

	/**
	 * Override this method to change the recipe identifier. The default implementation normalizes the namespace to the mod ID.
	 */
	protected class_2960 getRecipeIdentifier(class_2960 identifier) {
		return new class_2960(dataGenerator.getModId(), identifier.method_12832());
	}
}
