/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.datagen;

import java.util.function.Predicate;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_5413;
import net.minecraft.class_5414;
import net.minecraft.class_5415;

public class FabricTagEntry<T> extends class_3494.class_3497 {
	private static final class_5415 TAG_MANAGER = class_5413.method_33152();

	private final class_2378<T> registry;
	private final class_2960 id;
	private final boolean allowNonVanilla;

	public FabricTagEntry(class_2378<T> registry, class_2960 id, boolean allowNonVanilla) {
		super(id);

		this.registry = registry;
		this.id = id;
		this.allowNonVanilla = allowNonVanilla;
	}

	@Override
	public boolean method_32832(Predicate<class_2960> existenceTest, Predicate<class_2960> duplicationTest) {
		if (allowNonVanilla) {
			return true;
		}

		class_5414<T> tagGroup = TAG_MANAGER.method_33164(registry.method_30517());
		return tagGroup.method_34895(id) || super.method_32832(existenceTest, duplicationTest);
	}
}
