/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.minecraft.class_2403;
import net.minecraft.class_2408;
import net.minecraft.class_2444;
import net.minecraft.class_2446;
import net.minecraft.class_2960;

public abstract class FabricRecipesProvider
extends class_2446 {
    protected final FabricDataGenerator dataGenerator;

    public FabricRecipesProvider(FabricDataGenerator dataGenerator) {
        super((class_2403)dataGenerator);
        this.dataGenerator = dataGenerator;
    }

    protected abstract void generateRecipes(Consumer<class_2444> var1);

    protected Consumer<class_2444> withConditions(Consumer<class_2444> exporter, ConditionJsonProvider ... conditions) {
        Preconditions.checkArgument((conditions.length > 0 ? 1 : 0) != 0, (Object)"Must add at least one condition.");
        return json -> {
            FabricDataGenHelper.addConditions(json, conditions);
            exporter.accept((class_2444)json);
        };
    }

    public void method_10319(class_2408 cache) {
        Path path = this.field_11373.method_10313();
        HashSet generatedRecipes = Sets.newHashSet();
        this.generateRecipes(provider -> {
            class_2960 identifier = this.getRecipeIdentifier(provider.method_10417());
            if (!generatedRecipes.add(identifier)) {
                throw new IllegalStateException("Duplicate recipe " + identifier);
            }
            JsonObject recipeJson = provider.method_17799();
            ConditionJsonProvider[] conditions = FabricDataGenHelper.consumeConditions(provider);
            ConditionJsonProvider.write((JsonObject)recipeJson, (ConditionJsonProvider[])conditions);
            FabricRecipesProvider.method_10425((class_2408)cache, (JsonObject)recipeJson, (Path)path.resolve("data/" + identifier.method_12836() + "/recipes/" + identifier.method_12832() + ".json"));
            JsonObject advancementJson = provider.method_10415();
            if (advancementJson != null) {
                ConditionJsonProvider.write((JsonObject)advancementJson, (ConditionJsonProvider[])conditions);
                FabricRecipesProvider.method_10427((class_2408)cache, (JsonObject)advancementJson, (Path)path.resolve("data/" + identifier.method_12836() + "/advancements/" + provider.method_10418().method_12832() + ".json"));
            }
        });
    }

    protected class_2960 getRecipeIdentifier(class_2960 identifier) {
        return new class_2960(this.dataGenerator.getModId(), identifier.method_12832());
    }
}

