/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.datagen;

import com.mojang.serialization.Lifecycle;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FabricDataGenHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final boolean ENABLED = System.getProperty("fabric-api.datagen") != null;
    private static final String OUTPUT_DIR = System.getProperty("fabric-api.datagen.output-dir");
    private static final boolean STRICT_VALIDATION = System.getProperty("fabric-api.datagen.strict-validation") != null;
    @Nullable
    private static final String MOD_ID_FILTER = System.getProperty("fabric-api.datagen.modid");
    private static final String ENTRYPOINT_KEY = "fabric-datagen";
    private static final class_2378 FAKE_DYNAMIC_REGISTRY = new class_2370<Object>(class_5321.method_29180((class_2960)new class_2960("fabric:fake_dynamic_registry")), Lifecycle.experimental()){

        public boolean method_10250(class_2960 id) {
            return true;
        }
    };
    private static final Map<Object, ConditionJsonProvider[]> CONDITIONS_MAP = new IdentityHashMap<Object, ConditionJsonProvider[]>();

    private FabricDataGenHelper() {
    }

    public static void run() throws IOException {
        Path outputDir = Paths.get(Objects.requireNonNull(OUTPUT_DIR, "No output dir provided with the 'fabric-api.datagen.output-dir' property"), new String[0]);
        List dataGeneratorInitializers = FabricLoader.getInstance().getEntrypointContainers(ENTRYPOINT_KEY, DataGeneratorEntrypoint.class);
        if (dataGeneratorInitializers.isEmpty()) {
            LOGGER.warn("No data generator entrypoints are defined. Implement {} and add your class to the '{}' entrypoint key in your fabric.mod.json.", (Object)DataGeneratorEntrypoint.class.getName(), (Object)ENTRYPOINT_KEY);
        }
        for (EntrypointContainer entrypointContainer : dataGeneratorInitializers) {
            if (MOD_ID_FILTER != null && !entrypointContainer.getProvider().getMetadata().getId().equals(MOD_ID_FILTER)) continue;
            LOGGER.info("Running data generator for {}", (Object)entrypointContainer.getProvider().getMetadata().getName());
            FabricDataGenerator dataGenerator = new FabricDataGenerator(outputDir, entrypointContainer.getProvider(), STRICT_VALIDATION);
            ((DataGeneratorEntrypoint)entrypointContainer.getEntrypoint()).onInitializeDataGenerator(dataGenerator);
            dataGenerator.method_10315();
        }
    }

    public static <T> class_2378<T> getFakeDynamicRegistry() {
        return FAKE_DYNAMIC_REGISTRY;
    }

    public static void addConditions(Object object, ConditionJsonProvider[] conditions) {
        CONDITIONS_MAP.merge(object, conditions, ArrayUtils::addAll);
    }

    @Nullable
    public static ConditionJsonProvider[] consumeConditions(Object object) {
        return CONDITIONS_MAP.remove(object);
    }
}

