/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.datagen.v1.provider;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

import com.google.common.collect.Sets;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_173;
import net.minecraft.class_176;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_7701;
import net.minecraft.class_7788;
import net.minecraft.class_7923;

/**
 * Extend this class and implement {@link FabricBlockLootTableProvider#method_10379}.
 *
 * <p>Register an instance of the class with {@link FabricDataGenerator.Pack#addProvider} in a {@link net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint}
 */
public abstract class FabricBlockLootTableProvider extends class_7788 implements FabricLootTableProvider {
	private final FabricDataOutput output;
	private final Set<class_2960> excludedFromStrictValidation = new HashSet<>();

	protected FabricBlockLootTableProvider(FabricDataOutput dataOutput) {
		super(Collections.emptySet(), class_7701.field_40180.method_45383());
		this.output = dataOutput;
	}

	/**
	 * Implement this method to add block drops.
	 *
	 * <p>Use the range of {@link class_7788#method_46025} methods to generate block drops.
	 */
	@Override
	public abstract void method_10379();

	/**
	 * Disable strict validation for the passed block.
	 */
	public void excludeFromStrictValidation(class_2248 block) {
		excludedFromStrictValidation.add(class_7923.field_41175.method_10221(block));
	}

	@Override
	public class_176 getLootContextType() {
		return class_173.field_1172;
	}

	@Override
	public FabricDataOutput getFabricDataOutput() {
		return output;
	}

	@Override
	public void method_10399(BiConsumer<class_2960, class_52.class_53> biConsumer) {
		method_10379();

		for (Map.Entry<class_2960, class_52.class_53> entry : field_40610.entrySet()) {
			class_2960 identifier = entry.getKey();

			if (identifier.equals(class_39.field_844)) {
				continue;
			}

			biConsumer.accept(identifier, entry.getValue());
		}

		if (output.isStrictValidationEnabled()) {
			Set<class_2960> missing = Sets.newHashSet();

			for (class_2960 blockId : class_7923.field_41175.method_10235()) {
				if (blockId.method_12836().equals(output.getModId())) {
					if (!field_40610.containsKey(class_7923.field_41175.method_10223(blockId).method_26162())) {
						missing.add(blockId);
					}
				}
			}

			missing.removeAll(excludedFromStrictValidation);

			if (!missing.isEmpty()) {
				throw new IllegalStateException("Missing loot table(s) for %s".formatted(missing));
			}
		}
	}

	@Override
	public String method_10321() {
		return "Block Loot Tables";
	}
}
