/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.minecraft.class_176;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_60;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface FabricLootTableProvider
extends Consumer<BiConsumer<class_2960, class_52.class_53>>,
class_2405 {
    public class_176 getLootContextType();

    public FabricDataOutput getFabricDataOutput();

    default public BiConsumer<class_2960, class_52.class_53> withConditions(BiConsumer<class_2960, class_52.class_53> exporter, ConditionJsonProvider ... conditions) {
        Preconditions.checkArgument((conditions.length > 0 ? 1 : 0) != 0, (Object)"Must add at least one condition.");
        return (id, table) -> {
            FabricDataGenHelper.addConditions(table, conditions);
            exporter.accept((class_2960)id, (class_52.class_53)table);
        };
    }

    @ApiStatus.Internal
    default public CompletableFuture<?> method_10319(class_7403 writer) {
        HashMap builders = Maps.newHashMap();
        HashMap conditionMap = new HashMap();
        this.accept((identifier, builder) -> {
            ConditionJsonProvider[] conditions = FabricDataGenHelper.consumeConditions(builder);
            conditionMap.put(identifier, conditions);
            if (builders.put(identifier, builder.method_334(this.getLootContextType()).method_338()) != null) {
                throw new IllegalStateException("Duplicate loot table " + String.valueOf(identifier));
            }
        });
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (Map.Entry entry : builders.entrySet()) {
            JsonObject tableJson = (JsonObject)class_60.method_372((class_52)((class_52)entry.getValue()));
            ConditionJsonProvider.write((JsonObject)tableJson, (ConditionJsonProvider[])((ConditionJsonProvider[])conditionMap.remove(entry.getKey())));
            futures.add(class_2405.method_10320((class_7403)writer, (JsonElement)tableJson, (Path)this.getOutputPath((class_2960)entry.getKey())));
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private Path getOutputPath(class_2960 lootTableId) {
        return this.getFabricDataOutput().method_45973(class_7784.class_7490.field_39367, "loot_tables").method_44107(lootTableId);
    }
}

