/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.datagen.loot;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLootTableProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.minecraft.class_176;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_60;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public final class FabricLootTableProviderImpl {
    public static CompletableFuture<?> run(class_7403 writer, FabricLootTableProvider provider, class_176 lootContextType, FabricDataOutput fabricDataOutput) {
        HashMap builders = Maps.newHashMap();
        HashMap conditionMap = new HashMap();
        provider.method_10399((identifier, builder) -> {
            ConditionJsonProvider[] conditions = FabricDataGenHelper.consumeConditions(builder);
            conditionMap.put(identifier, conditions);
            if (builders.put(identifier, builder.method_334(lootContextType).method_338()) != null) {
                throw new IllegalStateException("Duplicate loot table " + String.valueOf(identifier));
            }
        });
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (Map.Entry entry : builders.entrySet()) {
            JsonObject tableJson = (JsonObject)class_60.method_372((class_52)((class_52)entry.getValue()));
            ConditionJsonProvider.write((JsonObject)tableJson, (ConditionJsonProvider[])((ConditionJsonProvider[])conditionMap.remove(entry.getKey())));
            futures.add(class_2405.method_10320((class_7403)writer, (JsonElement)tableJson, (Path)FabricLootTableProviderImpl.getOutputPath(fabricDataOutput, (class_2960)entry.getKey())));
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private static Path getOutputPath(FabricDataOutput dataOutput, class_2960 lootTableId) {
        return dataOutput.method_45973(class_7784.class_7490.field_39367, "loot_tables").method_44107(lootTableId);
    }

    private FabricLootTableProviderImpl() {
    }
}

