/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.impl.registry.sync.DynamicRegistriesImpl;
import net.minecraft.class_2378;
import net.minecraft.class_2405;
import net.minecraft.class_2922;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7655;
import net.minecraft.class_7784;
import net.minecraft.class_7871;
import net.minecraft.class_7876;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Experimental
public abstract class FabricDynamicRegistryProvider
implements class_2405 {
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricDynamicRegistryProvider.class);
    private final FabricDataOutput output;
    private final CompletableFuture<class_7225.class_7874> registriesFuture;

    public FabricDynamicRegistryProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        this.output = output;
        this.registriesFuture = registriesFuture;
    }

    protected abstract void configure(class_7225.class_7874 var1, Entries var2);

    public CompletableFuture<?> method_10319(class_7403 writer) {
        return this.registriesFuture.thenCompose(registries -> CompletableFuture.supplyAsync(() -> {
            Entries entries = new Entries((class_7225.class_7874)registries, this.output.getModId());
            this.configure((class_7225.class_7874)registries, entries);
            return entries;
        }).thenCompose(entries -> {
            class_6903 dynamicOps = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registries);
            ArrayList futures = new ArrayList();
            for (RegistryEntries<?> registryEntries : entries.queuedEntries.values()) {
                futures.add(this.writeRegistryEntries(writer, (class_6903<JsonElement>)dynamicOps, registryEntries));
            }
            return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        }));
    }

    private <T> CompletableFuture<?> writeRegistryEntries(class_7403 writer, class_6903<JsonElement> ops, RegistryEntries<T> entries) {
        class_5321 registry = entries.registry;
        boolean shouldOmitNamespace = registry.method_29177().method_12836().equals("minecraft") || !DynamicRegistriesImpl.FABRIC_DYNAMIC_REGISTRY_KEYS.contains(registry);
        String directoryName = shouldOmitNamespace ? registry.method_29177().method_12832() : registry.method_29177().method_12836() + "/" + registry.method_29177().method_12832();
        class_7784.class_7489 pathResolver = this.output.method_45973(class_7784.class_7490.field_39367, directoryName);
        ArrayList futures = new ArrayList();
        for (Map.Entry entry : entries.entries.entrySet()) {
            Path path = pathResolver.method_44107(entry.getKey().method_29177());
            futures.add(FabricDynamicRegistryProvider.writeToPath(path, writer, ops, entries.elementCodec, entry.getValue()));
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private static <E> CompletableFuture<?> writeToPath(Path path, class_7403 cache, DynamicOps<JsonElement> json, Encoder<E> encoder, E value) {
        Optional optional = encoder.encodeStart(json, value).resultOrPartial(error -> LOGGER.error("Couldn't serialize element {}: {}", (Object)path, error));
        if (optional.isPresent()) {
            return class_2405.method_10320((class_7403)cache, (JsonElement)((JsonElement)optional.get()), (Path)path);
        }
        return CompletableFuture.completedFuture(null);
    }

    private static class RegistryEntries<T> {
        final class_7876<T> lookup;
        final class_5321<? extends class_2378<T>> registry;
        final Codec<T> elementCodec;
        Map<class_5321<T>, T> entries = new IdentityHashMap<class_5321<T>, T>();

        RegistryEntries(class_7876<T> lookup, class_5321<? extends class_2378<T>> registry, Codec<T> elementCodec) {
            this.lookup = lookup;
            this.registry = registry;
            this.elementCodec = elementCodec;
        }

        static <T> RegistryEntries<T> create(class_7225.class_7874 lookups, class_7655.class_7657<T> loaderEntry) {
            class_7225.class_7226 lookup = lookups.method_46762(loaderEntry.comp_985());
            return new RegistryEntries<T>(lookup, loaderEntry.comp_985(), loaderEntry.comp_986());
        }

        public class_6880<T> add(class_5321<T> key, T value) {
            if (this.entries.put(key, value) != null) {
                throw new IllegalArgumentException("Trying to add registry key " + String.valueOf(key) + " more than once.");
            }
            return class_6880.class_6883.method_40234(this.lookup, key);
        }

        public class_6880<T> add(class_2960 id, T value) {
            return this.add(class_5321.method_29179(this.registry, (class_2960)id), value);
        }
    }

    public static final class Entries {
        private final class_7225.class_7874 registries;
        private final Map<class_2960, RegistryEntries<?>> queuedEntries;
        private final String modId;

        @ApiStatus.Internal
        Entries(class_7225.class_7874 registries, String modId) {
            this.registries = registries;
            this.queuedEntries = DynamicRegistries.getDynamicRegistries().stream().collect(Collectors.toMap(e -> e.comp_985().method_29177(), e -> RegistryEntries.create(registries, e)));
            this.modId = modId;
        }

        public class_7225.class_7874 getLookups() {
            return this.registries;
        }

        public <T> class_7871<T> getLookup(class_5321<? extends class_2378<T>> registryKey) {
            return this.registries.method_46762(registryKey);
        }

        public class_7871<class_6796> placedFeatures() {
            return this.getLookup(class_7924.field_41245);
        }

        public class_7871<class_2922<?>> configuredCarvers() {
            return this.getLookup(class_7924.field_41238);
        }

        public <T> class_6880<T> ref(class_5321<T> key) {
            RegistryEntries<T> entries = this.getQueuedEntries(key);
            return class_6880.class_6883.method_40234(entries.lookup, key);
        }

        public <T> class_6880<T> add(class_5321<T> registry, T object) {
            return this.getQueuedEntries(registry).add(registry.method_29177(), object);
        }

        public <T> class_6880<T> add(class_7225.class_7226<T> registry, class_5321<T> valueKey) {
            return this.add(valueKey, registry.method_46747(valueKey).comp_349());
        }

        public <T> List<class_6880<T>> addAll(class_7225.class_7226<T> registry) {
            return registry.method_46754().filter(registryKey -> registryKey.method_29177().method_12836().equals(this.modId)).map(key -> this.add(registry, (class_5321)key)).toList();
        }

        <T> RegistryEntries<T> getQueuedEntries(class_5321<T> key) {
            RegistryEntries<?> regEntries = this.queuedEntries.get(key.method_41185());
            if (regEntries == null) {
                throw new IllegalArgumentException("Registry " + String.valueOf(key.method_41185()) + " is not loaded from datapacks");
            }
            return regEntries;
        }
    }
}

