/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.datagen.loot;

import java.util.Collections;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.fabricmc.fabric.mixin.datagen.loot.BlockLootTableGeneratorAccessor;
import net.minecraft.class_2248;
import net.minecraft.class_52;
import net.minecraft.class_7701;
import net.minecraft.class_7788;

public class ConditionBlockLootTableGenerator extends class_7788 {
	private final class_7788 parent;
	private final ResourceCondition[] conditions;

	public ConditionBlockLootTableGenerator(class_7788 parent, ResourceCondition[] conditions) {
		super(Collections.emptySet(), class_7701.field_40180.method_45383(), ((BlockLootTableGeneratorAccessor) parent).getRegistryLookup());

		this.parent = parent;
		this.conditions = conditions;
	}

	@Override
	public void method_10379() {
		throw new UnsupportedOperationException("generate() should not be called.");
	}

	@Override
	public void method_45988(class_2248 block, class_52.class_53 lootTable) {
		FabricDataGenHelper.addConditions(lootTable, conditions);
		this.parent.method_45988(block, lootTable);
	}
}
