/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.datagen;

import com.google.gson.JsonElement;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4916;
import net.minecraft.class_4917;
import net.minecraft.class_5321;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_4916.class})
public class ModelProviderMixin {
    @Unique
    private FabricDataOutput fabricDataOutput;
    @Unique
    private static final ThreadLocal<FabricDataOutput> fabricDataOutputThreadLocal = new ThreadLocal();
    @Unique
    private static final ThreadLocal<Map<class_2248, class_4917>> blockStateMapThreadLocal = new ThreadLocal();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void init(class_7784 output, CallbackInfo ci) {
        if (output instanceof FabricDataOutput) {
            FabricDataOutput fabricDataOutput;
            this.fabricDataOutput = fabricDataOutput = (FabricDataOutput)output;
        }
    }

    @WrapOperation(method={"run"}, at={@At(value="INVOKE", target="Lnet/minecraft/data/client/BlockStateModelGenerator;register()V")})
    private void registerBlockStateModels(class_4910 instance, Operation<Void> original) {
        ModelProviderMixin modelProviderMixin = this;
        if (modelProviderMixin instanceof FabricModelProvider) {
            FabricModelProvider fabricModelProvider = (FabricModelProvider)((Object)modelProviderMixin);
            fabricModelProvider.generateBlockStateModels(instance);
        } else {
            original.call(new Object[]{instance});
        }
    }

    @WrapOperation(method={"run"}, at={@At(value="INVOKE", target="Lnet/minecraft/data/client/ItemModelGenerator;register()V")})
    private void registerItemModels(class_4915 instance, Operation<Void> original) {
        ModelProviderMixin modelProviderMixin = this;
        if (modelProviderMixin instanceof FabricModelProvider) {
            FabricModelProvider fabricModelProvider = (FabricModelProvider)((Object)modelProviderMixin);
            fabricModelProvider.generateItemModels(instance);
        } else {
            original.call(new Object[]{instance});
        }
    }

    @Inject(method={"run"}, at={@At(value="INVOKE_ASSIGN", target="com/google/common/collect/Maps.newHashMap()Ljava/util/HashMap;", ordinal=0, remap=false)})
    private void runHead(class_7403 writer, CallbackInfoReturnable<CompletableFuture<?>> cir, @Local Map<class_2248, class_4917> map) {
        fabricDataOutputThreadLocal.set(this.fabricDataOutput);
        blockStateMapThreadLocal.set(map);
    }

    @Inject(method={"run"}, at={@At(value="TAIL")})
    private void runTail(class_7403 writer, CallbackInfoReturnable<CompletableFuture<?>> cir) {
        fabricDataOutputThreadLocal.remove();
        blockStateMapThreadLocal.remove();
    }

    @ModifyArg(method={"run"}, at=@At(value="INVOKE", target="Ljava/util/stream/Stream;filter(Ljava/util/function/Predicate;)Ljava/util/stream/Stream;", ordinal=0, remap=false))
    private Predicate<Map.Entry<class_5321<class_2248>, class_2248>> filterBlocksForProcessingMod(Predicate<Map.Entry<class_5321<class_2248>, class_2248>> original) {
        if (this.fabricDataOutput != null) {
            return original.and(e -> this.fabricDataOutput.isStrictValidationEnabled()).and(e -> ((class_5321)e.getKey()).method_29177().method_12836().equals(this.fabricDataOutput.getModId()));
        }
        return original;
    }

    @Inject(method={"method_25741"}, at={@At(value="INVOKE", target="Lnet/minecraft/data/client/ModelIds;getItemModelId(Lnet/minecraft/item/Item;)Lnet/minecraft/util/Identifier;")}, cancellable=true)
    private static void filterItemsForProcessingMod(Set<class_1792> set, Map<class_2960, Supplier<JsonElement>> map, class_2248 block, CallbackInfo ci, @Local class_1792 item) {
        FabricDataOutput dataOutput = fabricDataOutputThreadLocal.get();
        if (dataOutput != null) {
            if (!blockStateMapThreadLocal.get().containsKey(block)) {
                ci.cancel();
                return;
            }
            if (!class_7923.field_41178.method_10221((Object)item).method_12836().equals(dataOutput.getModId())) {
                ci.cancel();
            }
        }
    }
}

