/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.datagen.client;

import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.impl.datagen.client.FabricModelProviderDefinitions;
import net.minecraft.class_10434;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_4916;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

@Mixin(class_4916.class_10407.class)
public class ModelProviderItemAssetsMixin implements FabricModelProviderDefinitions {
	@Shadow
	@Final
	private Map<class_1792, class_10434> itemAssets;
	@Unique
	private FabricDataOutput fabricDataOutput;

	@Override
	public void setFabricDataOutput(FabricDataOutput fabricDataOutput) {
		this.fabricDataOutput = fabricDataOutput;
	}

	@WrapOperation(method = "method_65470", at = @At(value = "INVOKE", target = "Ljava/util/Map;containsKey(Ljava/lang/Object;)Z", ordinal = 1, remap = false))
	private boolean filterItemsForProcessingMod(Map<class_1792, class_10434> map, Object o, Operation<Boolean> original) {
		class_1747 blockItem = (class_1747) o;

		if (fabricDataOutput != null) {
			// Only generate the item model if the block state json was registered
			if (itemAssets.containsKey(blockItem)) {
				return true;
			}

			if (!class_7923.field_41178.method_10221(blockItem).method_12836().equals(fabricDataOutput.getModId())) {
				// Skip over items that are not from the mod we are processing.
				return true;
			}
		}

		return original.call(map, blockItem);
	}

	@Redirect(method = "resolveAndValidate", at = @At(value = "INVOKE", target = "Ljava/util/stream/Stream;filter(Ljava/util/function/Predicate;)Ljava/util/stream/Stream;", ordinal = 0, remap = false))
	private Stream<class_6880.class_6883<class_1792>> filterItemsForProcessingMod(Stream<class_6880.class_6883<class_1792>> instance, Predicate<class_6880.class_6883<class_1792>> predicate) {
		return instance.filter((item) -> {
			if (fabricDataOutput != null) {
				if (!fabricDataOutput.isStrictValidationEnabled()) {
					return false;
				}

				if (!item.method_40237().method_29177().method_12836().equals(fabricDataOutput.getModId())) {
					// Skip over items that are not from the mod we are processing.
					return false;
				}
			}

			return predicate.test(item);
		});
	}
}
