/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.impl.datagen.ForcedTagEntry;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2474;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3495;
import net.minecraft.class_3497;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public abstract class FabricTagProvider<T>
extends class_2474<T> {
    private final FabricDataOutput output;
    private final Map<class_2960, AliasGroupBuilder> aliasGroupBuilders = new HashMap<class_2960, AliasGroupBuilder>();

    public FabricTagProvider(FabricDataOutput output, class_5321<? extends class_2378<T>> registryKey, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super((class_7784)output, registryKey, registriesFuture);
        this.output = output;
    }

    protected abstract void method_10514(class_7225.class_7874 var1);

    protected class_5321<T> reverseLookup(T element) {
        Optional key;
        class_2378 registry = (class_2378)class_7923.field_41167.method_29107(this.field_40957);
        if (registry != null && (key = registry.method_29113(element)).isPresent()) {
            return (class_5321)key.get();
        }
        throw new UnsupportedOperationException("Adding objects is not supported by " + String.valueOf(((Object)((Object)this)).getClass()));
    }

    protected FabricTagBuilder getOrCreateTagBuilder(class_6862<T> tag) {
        return new FabricTagBuilder(super.method_10512(tag));
    }

    protected AliasGroupBuilder aliasGroup(class_2960 groupId) {
        return this.aliasGroupBuilders.computeIfAbsent(groupId, key -> new AliasGroupBuilder());
    }

    protected AliasGroupBuilder aliasGroup(String group) {
        class_2960 groupId = class_2960.method_60655((String)this.output.getModId(), (String)group);
        return this.aliasGroupBuilders.computeIfAbsent(groupId, key -> new AliasGroupBuilder());
    }

    public Map<class_2960, AliasGroupBuilder> getAliasGroupBuilders() {
        return Collections.unmodifiableMap(this.aliasGroupBuilders);
    }

    public final class FabricTagBuilder
    extends class_2474.class_5124<T> {
        private final class_2474.class_5124<T> parent;

        private FabricTagBuilder(class_2474.class_5124<T> parent) {
            super(parent.field_23960);
            this.parent = parent;
        }

        public FabricTagBuilder setReplace(boolean replace) {
            ((net.fabricmc.fabric.impl.datagen.FabricTagBuilder)this.field_23960).fabric_setReplace(replace);
            return this;
        }

        public FabricTagBuilder add(T element) {
            this.add((class_5321<T>)FabricTagProvider.this.reverseLookup(element));
            return this;
        }

        @SafeVarargs
        public final FabricTagBuilder add(T ... elements) {
            for (Object element : elements) {
                this.add((class_5321<T>)FabricTagProvider.this.reverseLookup(element));
            }
            return this;
        }

        public FabricTagBuilder add(class_5321<T> registryKey) {
            this.parent.method_46835(registryKey);
            return this;
        }

        public FabricTagBuilder add(class_2960 id) {
            this.field_23960.method_26784(id);
            return this;
        }

        public FabricTagBuilder addOptional(class_2960 id) {
            this.parent.method_35922(id);
            return this;
        }

        public FabricTagBuilder addOptional(class_5321<? extends T> registryKey) {
            return this.addOptional(registryKey.method_29177());
        }

        public FabricTagBuilder addTag(class_6862<T> tag) {
            this.field_23960.method_26787(tag.comp_327());
            return this;
        }

        @SafeVarargs
        public final FabricTagBuilder addTags(class_6862<T> ... tags) {
            for (class_6862 tag : tags) {
                this.addTag(tag);
            }
            return this;
        }

        public FabricTagBuilder addOptionalTag(class_2960 id) {
            this.parent.method_35923(id);
            return this;
        }

        public FabricTagBuilder addOptionalTag(class_6862<T> tag) {
            return this.addOptionalTag(tag.comp_327());
        }

        @SafeVarargs
        public final FabricTagBuilder addOptionalTags(class_6862<T> ... tags) {
            for (class_6862 tag : tags) {
                this.addOptionalTag(tag);
            }
            return this;
        }

        public FabricTagBuilder forceAddTag(class_6862<T> tag) {
            this.field_23960.method_27064((class_3497)new ForcedTagEntry(class_3497.method_43937((class_2960)tag.comp_327())));
            return this;
        }

        @SafeVarargs
        public final FabricTagBuilder forceAddTags(class_6862<T> ... tags) {
            for (class_6862 tag : tags) {
                this.forceAddTag(tag);
            }
            return this;
        }

        public FabricTagBuilder add(class_2960 ... ids) {
            for (class_2960 id : ids) {
                this.add(id);
            }
            return this;
        }

        @SafeVarargs
        public final FabricTagBuilder add(class_5321<T> ... registryKeys) {
            for (class_5321 registryKey : registryKeys) {
                this.add((class_5321<T>)registryKey);
            }
            return this;
        }
    }

    public final class AliasGroupBuilder {
        private final List<class_6862<T>> tags = new ArrayList();

        private AliasGroupBuilder() {
        }

        public List<class_6862<T>> getTags() {
            return Collections.unmodifiableList(this.tags);
        }

        public AliasGroupBuilder add(class_6862<T> tag) {
            if (tag.comp_326() != FabricTagProvider.this.field_40957) {
                throw new IllegalArgumentException("Tag " + String.valueOf(tag) + " isn't from the registry " + String.valueOf(FabricTagProvider.this.field_40957));
            }
            this.tags.add(tag);
            return this;
        }

        @SafeVarargs
        public final AliasGroupBuilder add(class_6862<T> ... tags) {
            for (class_6862 tag : tags) {
                this.add((class_6862<T>)tag);
            }
            return this;
        }

        public AliasGroupBuilder add(class_2960 tag) {
            this.tags.add(class_6862.method_40092((class_5321)FabricTagProvider.this.field_40957, (class_2960)tag));
            return this;
        }

        public AliasGroupBuilder add(class_2960 ... tags) {
            for (class_2960 tag : tags) {
                this.tags.add(class_6862.method_40092((class_5321)FabricTagProvider.this.field_40957, (class_2960)tag));
            }
            return this;
        }
    }

    public static abstract class EntityTypeTagProvider
    extends FabricTagProvider<class_1299<?>> {
        public EntityTypeTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture) {
            super(output, class_7924.field_41266, completableFuture);
        }

        @Override
        protected class_5321<class_1299<?>> reverseLookup(class_1299<?> element) {
            return element.method_40124().method_40237();
        }
    }

    public static abstract class EnchantmentTagProvider
    extends FabricTagProvider<class_1887> {
        public EnchantmentTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture) {
            super(output, class_7924.field_41265, completableFuture);
        }
    }

    public static abstract class FluidTagProvider
    extends FabricTagProvider<class_3611> {
        public FluidTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture) {
            super(output, class_7924.field_41270, completableFuture);
        }

        @Override
        protected class_5321<class_3611> reverseLookup(class_3611 element) {
            return element.method_40178().method_40237();
        }
    }

    public static abstract class ItemTagProvider
    extends FabricTagProvider<class_1792> {
        @Nullable
        private final Function<class_6862<class_2248>, class_3495> blockTagBuilderProvider;

        public ItemTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture, @Nullable BlockTagProvider blockTagProvider) {
            super(output, class_7924.field_41197, completableFuture);
            this.blockTagBuilderProvider = blockTagProvider == null ? null : x$0 -> ((FabricTagProvider)blockTagProvider).method_27169(x$0);
        }

        public ItemTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture) {
            this(output, completableFuture, null);
        }

        public void copy(class_6862<class_2248> blockTag, class_6862<class_1792> itemTag) {
            class_3495 blockTagBuilder = Objects.requireNonNull(this.blockTagBuilderProvider, "Pass Block tag provider via constructor to use copy").apply(blockTag);
            class_3495 itemTagBuilder = this.method_27169(itemTag);
            blockTagBuilder.method_26782().forEach(arg_0 -> ((class_3495)itemTagBuilder).method_27064(arg_0));
        }

        @Override
        protected class_5321<class_1792> reverseLookup(class_1792 element) {
            return element.method_40131().method_40237();
        }
    }

    public static abstract class BlockEntityTypeTagProvider
    extends FabricTagProvider<class_2591<?>> {
        public BlockEntityTypeTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture) {
            super(output, class_7924.field_41255, completableFuture);
        }

        @Override
        protected class_5321<class_2591<?>> reverseLookup(class_2591<?> element) {
            return element.method_53254().method_40237();
        }
    }

    public static abstract class BlockTagProvider
    extends FabricTagProvider<class_2248> {
        public BlockTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, class_7924.field_41254, registriesFuture);
        }

        @Override
        protected class_5321<class_2248> reverseLookup(class_2248 element) {
            return element.method_40142().method_40237();
        }
    }
}

