/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.datagen.loot;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLootTableProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.minecraft.class_176;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7924;

public final class FabricLootTableProviderImpl {
    public static CompletableFuture<?> run(class_7403 writer, FabricLootTableProvider provider, class_176 contextType, FabricDataOutput fabricDataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        HashMap builders = Maps.newHashMap();
        HashMap conditionMap = new HashMap();
        return registryLookup.thenCompose(lookup -> {
            provider.method_10399((registryKey, builder) -> {
                ResourceCondition[] conditions = FabricDataGenHelper.consumeConditions(builder);
                conditionMap.put(registryKey.method_29177(), conditions);
                if (builders.put(registryKey.method_29177(), builder.method_334(contextType).method_338()) != null) {
                    throw new IllegalStateException("Duplicate loot table " + String.valueOf(registryKey.method_29177()));
                }
            });
            class_6903 ops = lookup.method_57093((DynamicOps)JsonOps.INSTANCE);
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            for (Map.Entry entry : builders.entrySet()) {
                JsonObject tableJson = (JsonObject)class_52.field_50021.encodeStart((DynamicOps)ops, (Object)((class_52)entry.getValue())).getOrThrow(IllegalStateException::new);
                FabricDataGenHelper.addConditions(tableJson, (ResourceCondition[])conditionMap.remove(entry.getKey()));
                futures.add(class_2405.method_10320((class_7403)writer, (JsonElement)tableJson, (Path)FabricLootTableProviderImpl.getOutputPath(fabricDataOutput, (class_2960)entry.getKey())));
            }
            return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        });
    }

    private static Path getOutputPath(FabricDataOutput dataOutput, class_2960 lootTableId) {
        return dataOutput.method_60917(class_7924.field_50079).method_44107(lootTableId);
    }

    private FabricLootTableProviderImpl() {
    }
}

