/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.datagen.client;

import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.impl.datagen.client.FabricItemAssetDefinitions;
import net.minecraft.class_10434;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_4916;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

@Mixin(class_4916.class_10407.class)
public class ModelProviderItemAssetsMixin implements FabricItemAssetDefinitions {
	@Unique
	private FabricDataOutput fabricDataOutput;
	@Unique
	private Set<class_2248> processedBlocks;

	@Override
	public void fabric_setProcessedBlocks(Set<class_2248> processedBlocks) {
		this.processedBlocks = processedBlocks;
	}

	@Override
	public void setFabricDataOutput(FabricDataOutput fabricDataOutput) {
		this.fabricDataOutput = fabricDataOutput;
	}

	@WrapOperation(method = "method_65470", at = @At(value = "INVOKE", target = "Ljava/util/Map;containsKey(Ljava/lang/Object;)Z", ordinal = 1))
	private boolean filterItemsForProcessingMod(Map<class_1792, class_10434> map, Object o, Operation<Boolean> original) {
		class_1747 blockItem = (class_1747) o;

		if (fabricDataOutput != null) {
			// Only generate the item model if the block state json was registered
			if (!processedBlocks.contains(blockItem.method_7711())) {
				return true;
			}

			if (!class_7923.field_41178.method_10221(blockItem).method_12836().equals(fabricDataOutput.getModId())) {
				// Skip over items that are not from the mod we are processing.
				return true;
			}
		}

		return original.call(map, o);
	}

	@ModifyArg(method = "resolveAndValidate", at = @At(value = "INVOKE", target = "Ljava/util/stream/Stream;filter(Ljava/util/function/Predicate;)Ljava/util/stream/Stream;", ordinal = 0))
	private Predicate<class_6880.class_6883<class_1792>> filterItemsForProcessingMod(Predicate<class_6880.class_6883<class_1792>> original) {
		if (fabricDataOutput != null) {
			return original
					.and(item -> fabricDataOutput.isStrictValidationEnabled())
					// Skip over items that are not from the mod we are processing.
					.and(item -> item.method_40237().method_29177().method_12836().equals(fabricDataOutput.getModId()));
		}

		return original;
	}
}
