/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLootTableProvider;
import net.fabricmc.fabric.impl.datagen.loot.FabricLootTableProviderImpl;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public abstract class FabricBlockLootTableProvider
extends BlockLootSubProvider
implements FabricLootTableProvider {
    private final FabricDataOutput output;
    private final Set<Identifier> excludedFromStrictValidation = new HashSet<Identifier>();
    private final CompletableFuture<HolderLookup.Provider> registryLookupFuture;

    protected FabricBlockLootTableProvider(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
        super(Collections.emptySet(), FeatureFlags.REGISTRY.allFlags(), registryLookup.join());
        this.output = dataOutput;
        this.registryLookupFuture = registryLookup;
    }

    public abstract void generate();

    public void excludeFromStrictValidation(Block block) {
        this.excludedFromStrictValidation.add(BuiltInRegistries.BLOCK.getKey((Object)block));
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> biConsumer) {
        this.generate();
        for (Map.Entry entry : this.map.entrySet()) {
            ResourceKey registryKey = (ResourceKey)entry.getKey();
            biConsumer.accept((ResourceKey<LootTable>)registryKey, (LootTable.Builder)entry.getValue());
        }
        if (this.output.isStrictValidationEnabled()) {
            HashSet missing = Sets.newHashSet();
            for (Identifier blockId : BuiltInRegistries.BLOCK.keySet()) {
                Optional blockLootTableId;
                if (!blockId.getNamespace().equals(this.output.getModId()) || !(blockLootTableId = ((Block)BuiltInRegistries.BLOCK.getValue(blockId)).getLootTable()).isPresent() || !((ResourceKey)blockLootTableId.get()).identifier().getNamespace().equals(this.output.getModId()) || this.map.containsKey(blockLootTableId.get())) continue;
                missing.add(blockId);
            }
            missing.removeAll(this.excludedFromStrictValidation);
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing loot table(s) for %s".formatted(missing));
            }
        }
    }

    public CompletableFuture<?> run(CachedOutput writer) {
        return FabricLootTableProviderImpl.run(writer, this, LootContextParamSets.BLOCK, this.output, this.registryLookupFuture);
    }

    public String getName() {
        return "Block Loot Tables";
    }
}

