/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2378;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public abstract class FabricCodecDataProvider<T>
implements class_2405 {
    private final class_7784.class_7489 pathResolver;
    private final CompletableFuture<class_7225.class_7874> registriesFuture;
    private final Codec<T> codec;

    private FabricCodecDataProvider(class_7784.class_7489 pathResolver, CompletableFuture<class_7225.class_7874> registriesFuture, Codec<T> codec) {
        this.pathResolver = pathResolver;
        this.registriesFuture = Objects.requireNonNull(registriesFuture);
        this.codec = codec;
    }

    protected FabricCodecDataProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registriesFuture, class_7784.class_7490 outputType, String directoryName, Codec<T> codec) {
        this(dataOutput.method_45973(outputType, directoryName), registriesFuture, codec);
    }

    protected FabricCodecDataProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registriesFuture, class_5321<? extends class_2378<?>> key, Codec<T> codec) {
        this(dataOutput.method_60917(key), registriesFuture, codec);
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        return this.registriesFuture.thenCompose(lookup -> {
            HashMap<class_2960, JsonElement> entries = new HashMap<class_2960, JsonElement>();
            class_6903 ops = lookup.method_57093((DynamicOps)JsonOps.INSTANCE);
            BiConsumer<class_2960, Object> provider = (id, value) -> {
                JsonElement json = this.convert((class_2960)id, (T)value, (DynamicOps<JsonElement>)ops);
                JsonElement existingJson = entries.put((class_2960)id, json);
                if (existingJson != null) {
                    throw new IllegalArgumentException("Duplicate entry " + String.valueOf(id));
                }
            };
            this.configure((BiConsumer<class_2960, T>)provider, (class_7225.class_7874)lookup);
            return this.write(writer, entries);
        });
    }

    protected abstract void configure(BiConsumer<class_2960, T> var1, class_7225.class_7874 var2);

    private JsonElement convert(class_2960 id, T value, DynamicOps<JsonElement> ops) {
        DataResult dataResult = this.codec.encodeStart(ops, value);
        return (JsonElement)dataResult.mapError(message -> "Invalid entry %s: %s".formatted(id, message)).getOrThrow();
    }

    private CompletableFuture<?> write(class_7403 writer, Map<class_2960, JsonElement> entries) {
        return CompletableFuture.allOf((CompletableFuture[])entries.entrySet().stream().map(entry -> {
            Path path = this.pathResolver.method_44107((class_2960)entry.getKey());
            return class_2405.method_10320((class_7403)writer, (JsonElement)((JsonElement)entry.getValue()), (Path)path);
        }).toArray(CompletableFuture[]::new));
    }
}

