/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagAppender;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import org.jspecify.annotations.Nullable;

public abstract class FabricTagProvider<T>
extends TagsProvider<T> {
    private final FabricDataOutput output;
    private final Map<Identifier, AliasGroupBuilder> aliasGroupBuilders = new HashMap<Identifier, AliasGroupBuilder>();

    public FabricTagProvider(FabricDataOutput output, ResourceKey<? extends Registry<T>> registryKey, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        super((PackOutput)output, registryKey, registriesFuture);
        this.output = output;
    }

    protected abstract void addTags(HolderLookup.Provider var1);

    protected TagAppender<ResourceKey<T>, T> builder(TagKey<T> tag) {
        TagBuilder tagBuilder = this.getOrCreateRawBuilder(tag);
        return TagAppender.forBuilder((TagBuilder)tagBuilder);
    }

    protected AliasGroupBuilder aliasGroup(Identifier groupId) {
        return this.aliasGroupBuilders.computeIfAbsent(groupId, key -> new AliasGroupBuilder(this));
    }

    protected AliasGroupBuilder aliasGroup(String group) {
        Identifier groupId = Identifier.fromNamespaceAndPath((String)this.output.getModId(), (String)group);
        return this.aliasGroupBuilders.computeIfAbsent(groupId, key -> new AliasGroupBuilder(this));
    }

    public Map<Identifier, AliasGroupBuilder> getAliasGroupBuilders() {
        return Collections.unmodifiableMap(this.aliasGroupBuilders);
    }

    public final class AliasGroupBuilder {
        private final List<TagKey<T>> tags;
        final /* synthetic */ FabricTagProvider this$0;

        private AliasGroupBuilder(FabricTagProvider this$0) {
            FabricTagProvider fabricTagProvider = this$0;
            Objects.requireNonNull(fabricTagProvider);
            this.this$0 = fabricTagProvider;
            this.tags = new ArrayList();
        }

        public List<TagKey<T>> getTags() {
            return Collections.unmodifiableList(this.tags);
        }

        public AliasGroupBuilder add(TagKey<T> tag) {
            if (tag.registry() != this.this$0.registryKey) {
                throw new IllegalArgumentException("Tag " + String.valueOf(tag) + " isn't from the registry " + String.valueOf(this.this$0.registryKey));
            }
            this.tags.add(tag);
            return this;
        }

        @SafeVarargs
        public final AliasGroupBuilder add(TagKey<T> ... tags) {
            for (TagKey tag : tags) {
                this.add((TagKey<T>)tag);
            }
            return this;
        }

        public AliasGroupBuilder add(Identifier tag) {
            this.tags.add(TagKey.create((ResourceKey)this.this$0.registryKey, (Identifier)tag));
            return this;
        }

        public AliasGroupBuilder add(Identifier ... tags) {
            for (Identifier tag : tags) {
                this.tags.add(TagKey.create((ResourceKey)this.this$0.registryKey, (Identifier)tag));
            }
            return this;
        }
    }

    public static abstract class EntityTypeTagProvider
    extends FabricValueLookupTagProvider<EntityType<?>> {
        public EntityTypeTagProvider(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, Registries.ENTITY_TYPE, registriesFuture, type -> type.builtInRegistryHolder().key());
        }
    }

    public static abstract class FluidTagProvider
    extends FabricValueLookupTagProvider<Fluid> {
        public FluidTagProvider(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, Registries.FLUID, registriesFuture, fluid -> fluid.builtInRegistryHolder().key());
        }
    }

    public static abstract class ItemTagProvider
    extends FabricValueLookupTagProvider<Item> {
        private final @Nullable Function<TagKey<Block>, TagBuilder> blockTagBuilderProvider;

        public ItemTagProvider(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture, @Nullable BlockTagProvider blockTagProvider) {
            super(output, Registries.ITEM, registriesFuture, item -> item.builtInRegistryHolder().key());
            Function<TagKey, TagBuilder> function;
            if (blockTagProvider == null) {
                function = null;
            } else {
                BlockTagProvider blockTagProvider2 = blockTagProvider;
                Objects.requireNonNull(blockTagProvider2);
                BlockTagProvider blockTagProvider3 = blockTagProvider2;
                function = x$0 -> ((FabricTagProvider)blockTagProvider3).getOrCreateRawBuilder(x$0);
            }
            this.blockTagBuilderProvider = function;
        }

        public ItemTagProvider(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            this(output, registriesFuture, null);
        }

        public void copy(TagKey<Block> blockTag, TagKey<Item> itemTag) {
            TagBuilder blockTagBuilder = Objects.requireNonNull(this.blockTagBuilderProvider, "Pass Block tag provider via constructor to use copy").apply(blockTag);
            TagBuilder itemTagBuilder = this.getOrCreateRawBuilder(itemTag);
            blockTagBuilder.build().forEach(arg_0 -> ((TagBuilder)itemTagBuilder).add(arg_0));
        }
    }

    public static abstract class BlockEntityTypeTagProvider
    extends FabricValueLookupTagProvider<BlockEntityType<?>> {
        public BlockEntityTypeTagProvider(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, Registries.BLOCK_ENTITY_TYPE, registriesFuture, type -> type.builtInRegistryHolder().key());
        }
    }

    public static abstract class BlockTagProvider
    extends FabricValueLookupTagProvider<Block> {
        public BlockTagProvider(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, Registries.BLOCK, registriesFuture, block -> block.builtInRegistryHolder().key());
        }
    }

    public static abstract class FabricValueLookupTagProvider<T>
    extends FabricTagProvider<T> {
        private final Function<T, ResourceKey<T>> valueToKey;

        protected FabricValueLookupTagProvider(FabricDataOutput output, ResourceKey<? extends Registry<T>> registryKey, CompletableFuture<HolderLookup.Provider> registriesFuture, Function<T, ResourceKey<T>> valueToKey) {
            super(output, registryKey, registriesFuture);
            this.valueToKey = valueToKey;
        }

        protected TagAppender<T, T> valueLookupBuilder(TagKey<T> tag) {
            TagBuilder tagBuilder = this.getOrCreateRawBuilder(tag);
            return TagAppender.forBuilder((TagBuilder)tagBuilder).map(this.valueToKey);
        }
    }
}

